/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.mock;

import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.opennms.netmgt.dao.api.AbstractInterfaceToNodeCache;

public class MockInterfaceToNodeCache
extends AbstractInterfaceToNodeCache {
    private Map<Key, Integer> keyToNodeId = Maps.newHashMap();

    public boolean setNodeId(String location, InetAddress ipAddr, int nodeId) {
        return this.keyToNodeId.put(new Key(location, ipAddr), nodeId) != null;
    }

    public boolean removeNodeId(String location, InetAddress ipAddr, int nodeId) {
        return this.keyToNodeId.remove(new Key(location, ipAddr)) != null;
    }

    public Iterable<Integer> getNodeId(String location, InetAddress ipAddr) {
        Integer nodeId = this.keyToNodeId.get(new Key(location, ipAddr));
        if (nodeId != null) {
            return Arrays.asList(nodeId);
        }
        return Collections.emptySet();
    }

    public void dataSourceSync() {
    }

    public int size() {
        return this.keyToNodeId.size();
    }

    public void clear() {
        this.keyToNodeId.clear();
    }

    public void removeInterfacesForNode(int nodeId) {
    }

    private static class Key {
        private String location;
        private InetAddress ipAddr;

        public Key(String location, InetAddress ipAddr) {
            this.location = location;
            this.ipAddr = ipAddr;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.location, key.location) && Objects.equals(this.ipAddr, key.ipAddr);
        }

        public int hashCode() {
            return Objects.hash(this.location, this.ipAddr);
        }
    }
}

