/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.mock;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.criterion.Criterion;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.netmgt.dao.mock.AbstractMockDao;
import org.opennms.netmgt.model.OnmsCategory;

public class MockCategoryDao
extends AbstractMockDao<OnmsCategory, Integer>
implements CategoryDao {
    private AtomicInteger m_id = new AtomicInteger(0);

    @Override
    protected void generateId(OnmsCategory cat) {
        cat.setId(Integer.valueOf(this.m_id.incrementAndGet()));
    }

    @Override
    protected Integer getId(OnmsCategory cat) {
        return cat.getId();
    }

    @Override
    public Integer save(OnmsCategory cat) {
        if (cat == null) {
            return null;
        }
        String categoryName = cat.getName();
        if (categoryName == null) {
            return null;
        }
        OnmsCategory existingCategory = this.findByName(categoryName);
        if (existingCategory == null) {
            return (Integer)super.save(cat);
        }
        cat.setId(existingCategory.getId());
        cat.setDescription(existingCategory.getDescription());
        cat.setAuthorizedGroups(existingCategory.getAuthorizedGroups());
        return cat.getId();
    }

    public OnmsCategory findByName(String name) {
        for (OnmsCategory cat : this.findAll()) {
            if (!name.equals(cat.getName())) continue;
            return cat;
        }
        return null;
    }

    public OnmsCategory findByName(String name, boolean useCached) {
        return this.findByName(name);
    }

    public List<String> getAllCategoryNames() {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public List<Criterion> getCriterionForCategorySetsUnion(String[] ... categories) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public List<OnmsCategory> getCategoriesWithAuthorizedGroup(String groupName) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }
}

