/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.mock;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opennms.netmgt.dao.api.CountedObject;
import org.opennms.netmgt.dao.api.EventCountDao;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.dao.mock.AbstractMockDao;
import org.opennms.netmgt.model.OnmsEvent;

public class MockEventDao
extends AbstractMockDao<OnmsEvent, Integer>
implements EventDao,
EventCountDao {
    private AtomicInteger m_id = new AtomicInteger(0);

    @Override
    protected void generateId(OnmsEvent event) {
        event.setId(Integer.valueOf(this.m_id.incrementAndGet()));
    }

    @Override
    protected Integer getId(OnmsEvent event) {
        Integer id = event.getId();
        return id == null || id == 0 ? null : id;
    }

    public int deletePreviousEventsForAlarm(Integer id, OnmsEvent e) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public List<OnmsEvent> getEventsAfterDate(List<String> ueiList, Date date) {
        ArrayList<OnmsEvent> matchingEvents = new ArrayList<OnmsEvent>();
        List allEvents = this.findAll();
        for (OnmsEvent eachEvent : allEvents) {
            if (!ueiList.contains(eachEvent.getEventUei()) || !eachEvent.getEventTime().after(date)) continue;
            matchingEvents.add(eachEvent);
        }
        return matchingEvents;
    }

    public Set<CountedObject<String>> getUeiCounts(Integer limit) {
        HashMap<String, Long> counts = new HashMap<String, Long>();
        for (OnmsEvent event : this.findAll()) {
            String eventUei = event.getEventUei();
            if (!counts.containsKey(eventUei)) {
                counts.put(eventUei, 0L);
            }
            counts.put(eventUei, (Long)counts.get(eventUei) + 1L);
        }
        HashSet<CountedObject<String>> countedObjects = new HashSet<CountedObject<String>>();
        for (String uei : counts.keySet()) {
            countedObjects.add((CountedObject<String>)new CountedObject((Object)uei, (Long)counts.get(uei)));
        }
        return countedObjects;
    }

    public List<OnmsEvent> getEventsForEventParameters(Map<String, String> eventParameters) {
        Stream<Object> stream = this.findAll().stream();
        for (Map.Entry<String, String> entry : eventParameters.entrySet()) {
            stream = stream.filter(e -> e.getEventParameters().stream().anyMatch(p -> p.getName().matches(((String)entry.getKey()).replaceAll("%", ".*")) && p.getValue().matches(((String)entry.getValue()).replace("%", ".*"))));
        }
        return stream.distinct().collect(Collectors.toList());
    }
}

