/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.mock;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.mock.AbstractMockDao;
import org.opennms.netmgt.model.HeatMapElement;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.alarm.AlarmSummary;
import org.opennms.netmgt.model.topology.EdgeAlarmStatusSummary;

public class MockAlarmDao
extends AbstractMockDao<OnmsAlarm, Integer>
implements AlarmDao {
    private AtomicInteger m_id = new AtomicInteger(0);

    @Override
    public Integer save(OnmsAlarm alarm) {
        Integer retval = (Integer)super.save(alarm);
        this.updateSubObjects(alarm);
        return retval;
    }

    @Override
    public void update(OnmsAlarm alarm) {
        super.update(alarm);
        this.updateSubObjects(alarm);
    }

    private void updateSubObjects(OnmsAlarm alarm) {
        this.getDistPollerDao().save((Object)((OnmsDistPoller)alarm.getDistPoller()));
        this.getEventDao().save((Object)alarm.getLastEvent());
        this.getNodeDao().save((Object)alarm.getNode());
        this.getServiceTypeDao().save((Object)alarm.getServiceType());
    }

    @Override
    protected void generateId(OnmsAlarm alarm) {
        alarm.setId(Integer.valueOf(this.m_id.incrementAndGet()));
    }

    @Override
    protected Integer getId(OnmsAlarm alarm) {
        return alarm.getId();
    }

    public OnmsAlarm findByReductionKey(String reductionKey) {
        for (OnmsAlarm alarm : this.findAll()) {
            if (!alarm.getReductionKey().equals(reductionKey)) continue;
            return alarm;
        }
        return null;
    }

    public List<AlarmSummary> getNodeAlarmSummaries() {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public List<AlarmSummary> getNodeAlarmSummariesIncludeAcknowledgedOnes(List<Integer> nodeIds) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public List<EdgeAlarmStatusSummary> getLldpEdgeAlarmSummaries(List<Integer> lldpLinkIds) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public List<HeatMapElement> getHeatMapItemsForEntity(String entityNameColumn, String entityIdColumn, boolean processAcknowledgedAlarms, String restrictionColumn, String restrictionValue, String ... groupByColumns) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public List<OnmsAlarm> getAlarmsForEventParameters(Map<String, String> eventParameters) {
        Stream<Object> stream = this.findAll().stream();
        for (Map.Entry<String, String> entry : eventParameters.entrySet()) {
            stream = stream.filter(e -> e.getEventParameters().stream().anyMatch(p -> p.getName().matches(((String)entry.getKey()).replaceAll("%", ".*")) && p.getValue().matches(((String)entry.getValue()).replace("%", ".*"))));
        }
        return stream.distinct().collect(Collectors.toList());
    }
}

