/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.mock;

import java.io.Serializable;
import java.util.ArrayList;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ServiceTypeDao;
import org.opennms.netmgt.dao.util.AutoAction;
import org.opennms.netmgt.dao.util.Correlation;
import org.opennms.netmgt.dao.util.Forward;
import org.opennms.netmgt.dao.util.OperatorAction;
import org.opennms.netmgt.dao.util.SnmpInfo;
import org.opennms.netmgt.events.api.EventDatabaseConstants;
import org.opennms.netmgt.events.api.EventParameterUtils;
import org.opennms.netmgt.events.api.EventProcessor;
import org.opennms.netmgt.events.api.EventProcessorException;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsMonitoringSystem;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.xml.event.Autoaction;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Log;
import org.opennms.netmgt.xml.event.Operaction;
import org.opennms.netmgt.xml.event.Snmp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.util.Assert;

public class MockEventWriter
implements EventProcessor,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(MockEventWriter.class);
    private static final int EVENT_AUTOACTION_FIELD_SIZE = 256;
    private static final int EVENT_CORRELATION_FIELD_SIZE = 1024;
    private static final int EVENT_FORWARD_FIELD_SIZE = 256;
    private static final int EVENT_OPERACTION_FIELD_SIZE = 256;
    private static final int EVENT_OPERACTION_MENU_FIELD_SIZE = 64;
    private static final int EVENT_SNMPHOST_FIELD_SIZE = 256;
    private static final int EVENT_SNMP_FIELD_SIZE = 256;
    private static final int EVENT_TTICKET_FIELD_SIZE = 128;
    private EventDao m_eventDao;
    private DistPollerDao m_distPollerDao;
    private NodeDao m_nodeDao;
    private ServiceTypeDao m_serviceTypeDao;

    public EventDao getEventDao() {
        return this.m_eventDao;
    }

    public void setEventDao(EventDao eventDao) {
        this.m_eventDao = eventDao;
    }

    public DistPollerDao getDistPollerDao() {
        return this.m_distPollerDao;
    }

    public void setDistPollerDao(DistPollerDao distPollerDao) {
        this.m_distPollerDao = distPollerDao;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public ServiceTypeDao getServiceTypeDao() {
        return this.m_serviceTypeDao;
    }

    public void setServiceTypeDao(ServiceTypeDao serviceTypeDao) {
        this.m_serviceTypeDao = serviceTypeDao;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_eventDao);
        Assert.notNull((Object)this.m_distPollerDao);
        Assert.notNull((Object)this.m_nodeDao);
        Assert.notNull((Object)this.m_serviceTypeDao);
    }

    public void process(Log eventLog) throws EventProcessorException {
        this.process(eventLog, false);
    }

    public void process(Log eventLog, boolean synchronous) throws EventProcessorException {
        if (eventLog != null && eventLog.getEvents() != null && eventLog.getEvents().getEvent() != null) {
            for (Event event : eventLog.getEvents().getEvent()) {
                this.process(event);
            }
        }
    }

    private void process(Event event) throws EventProcessorException {
        LOG.debug("Writing event: {}", (Object)event);
        OnmsEvent oe = new OnmsEvent();
        oe.setEventAutoAction(event.getAutoactionCount() > 0 ? AutoAction.format((Autoaction[])event.getAutoaction(), (int)256) : null);
        oe.setEventCorrelation(event.getCorrelation() != null ? Correlation.format((org.opennms.netmgt.xml.event.Correlation)event.getCorrelation(), (int)1024) : null);
        oe.setEventCreateTime(event.getCreationTime());
        oe.setId(event.getDbid());
        oe.setEventDescr(event.getDescr());
        try {
            oe.setDistPoller((OnmsMonitoringSystem)this.m_distPollerDao.get((Serializable)((Object)event.getDistPoller())));
        }
        catch (DataAccessException e) {
            throw new EventProcessorException((Throwable)e);
        }
        oe.setEventHost(event.getHost());
        oe.setEventForward(event.getForwardCount() > 0 ? Forward.format((org.opennms.netmgt.xml.event.Forward[])event.getForward(), (int)256) : null);
        oe.setIfIndex(event.getIfIndex());
        oe.setIpAddr(event.getInterfaceAddress());
        if (event.getLogmsg() != null) {
            oe.setEventLogMsg(EventDatabaseConstants.format((String)event.getLogmsg().getContent(), (int)0));
            String logdest = event.getLogmsg().getDest();
            if (logdest.equals("logndisplay")) {
                oe.setEventLog("Y");
                oe.setEventDisplay("Y");
            } else if (logdest.equals("logonly")) {
                oe.setEventLog("Y");
                oe.setEventDisplay("N");
            } else if (logdest.equals("displayonly")) {
                oe.setEventLog("N");
                oe.setEventDisplay("Y");
            } else if (logdest.equals("suppress")) {
                oe.setEventLog("N");
                oe.setEventDisplay("N");
            }
        }
        oe.setEventMouseOverText(event.getMouseovertext());
        try {
            oe.setNode((OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(event.getNodeid().intValue())));
        }
        catch (DataAccessException e) {
            throw new EventProcessorException((Throwable)e);
        }
        if (event.getOperactionCount() > 0) {
            ArrayList<Operaction> a = new ArrayList<Operaction>();
            ArrayList<String> b = new ArrayList<String>();
            for (Operaction eoa : event.getOperactionCollection()) {
                a.add(eoa);
                b.add(eoa.getMenutext());
            }
            oe.setEventOperAction(OperatorAction.format(a, (int)256));
            oe.setEventOperActionMenuText(EventDatabaseConstants.format(b, (int)64));
        }
        oe.setEventOperInstruct(event.getOperinstruct());
        oe.setEventParms(EventParameterUtils.format((Event)event));
        oe.setEventPathOutage(event.getPathoutage());
        try {
            oe.setServiceType(this.m_serviceTypeDao.findByName(event.getService()));
        }
        catch (DataAccessException e) {
            throw new EventProcessorException((Throwable)e);
        }
        oe.setSeverityLabel(event.getSeverity());
        oe.setEventSnmp(SnmpInfo.format((Snmp)event.getSnmp(), (int)256));
        oe.setEventSnmpHost(EventDatabaseConstants.format((String)event.getSnmphost(), (int)256));
        oe.setEventSource(event.getSource());
        oe.setEventTime(event.getTime());
        if (event.getTticket() != null) {
            oe.setEventTTicket(EventDatabaseConstants.format((String)event.getTticket().getContent(), (int)128));
            oe.setEventTTicketState(Integer.valueOf(event.getTticket().getState().equals("on") ? 1 : 0));
        }
        oe.setEventUei(event.getUei());
        this.m_eventDao.saveOrUpdate((Object)oe);
    }
}

