/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.mock;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.opennms.netmgt.dao.api.EventdServiceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.util.Assert;

public class JdbcEventdServiceManager
implements InitializingBean,
EventdServiceManager {
    private static final String SQL_DB_SVC_TABLE_READ = "SELECT serviceID, serviceName FROM service";
    private static final Logger LOG = LoggerFactory.getLogger(JdbcEventdServiceManager.class);
    private DataSource m_dataSource;
    private Map<String, Integer> m_serviceMap = new HashMap<String, Integer>();

    public synchronized int getServiceId(String serviceName) throws DataAccessException {
        int serviceId;
        Assert.notNull((Object)serviceName, (String)"The serviceName argument must not be null");
        if (this.m_serviceMap.containsKey(serviceName)) {
            return this.m_serviceMap.get(serviceName);
        }
        LOG.debug("Could not find entry for '{}' in service name cache.  Looking up in database.", (Object)serviceName);
        try {
            serviceId = new JdbcTemplate(this.m_dataSource).queryForInt("SELECT serviceID FROM service WHERE serviceName = ?", new Object[]{serviceName});
        }
        catch (IncorrectResultSizeDataAccessException e) {
            if (e.getActualSize() == 0) {
                LOG.debug("Did not find entry for '{}' in database.", (Object)serviceName);
                return -1;
            }
            throw e;
        }
        this.m_serviceMap.put(serviceName, serviceId);
        LOG.debug("Found entry for '{}' (ID {}) in database.  Adding to service name cache.", (Object)serviceName, (Object)serviceId);
        return serviceId;
    }

    public synchronized void dataSourceSync() {
        this.m_serviceMap.clear();
        new JdbcTemplate(this.m_dataSource).query(SQL_DB_SVC_TABLE_READ, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                JdbcEventdServiceManager.this.m_serviceMap.put(resultSet.getString(2), resultSet.getInt(1));
            }
        });
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_dataSource != null ? 1 : 0) != 0, (String)"property dataSource must be set");
    }

    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }
}

