/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.mock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import org.opennms.netmgt.config.monitoringLocations.LocationDef;
import org.opennms.netmgt.dao.api.LocationMonitorDao;
import org.opennms.netmgt.dao.mock.AbstractMockDao;
import org.opennms.netmgt.model.LocationMonitorIpInterface;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsLocationSpecificStatus;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.springframework.util.Assert;

public class MockLocationMonitorDao
extends AbstractMockDao<OnmsLocationMonitor, String>
implements LocationMonitorDao {
    private Set<OnmsLocationSpecificStatus> m_statuses = new LinkedHashSet<OnmsLocationSpecificStatus>();

    @Override
    protected void generateId(OnmsLocationMonitor mon) {
        mon.setId(UUID.randomUUID().toString());
    }

    @Override
    protected String getId(OnmsLocationMonitor loc) {
        return loc.getId();
    }

    public Collection<OnmsLocationMonitor> findByLocationDefinition(LocationDef locationDefinition) {
        HashSet<OnmsLocationMonitor> monitors = new HashSet<OnmsLocationMonitor>();
        for (OnmsLocationMonitor mon : this.findAll()) {
            if (!mon.getLocation().equals(locationDefinition.getLocationName())) continue;
            monitors.add(mon);
        }
        return monitors;
    }

    public Collection<OnmsLocationMonitor> findByApplication(OnmsApplication application) {
        HashSet<OnmsLocationMonitor> monitors = new HashSet<OnmsLocationMonitor>();
        for (OnmsLocationSpecificStatus stat : this.getAllMostRecentStatusChanges()) {
            if (!stat.getMonitoredService().getApplications().contains(application)) continue;
            monitors.add(stat.getLocationMonitor());
        }
        return monitors;
    }

    public void saveStatusChange(OnmsLocationSpecificStatus status) {
        this.m_statuses.add(status);
    }

    public OnmsLocationSpecificStatus getMostRecentStatusChange(OnmsLocationMonitor locationMonitor, OnmsMonitoredService monSvc) {
        Iterator<OnmsLocationSpecificStatus> it = new LinkedList<OnmsLocationSpecificStatus>(this.m_statuses).descendingIterator();
        while (it.hasNext()) {
            OnmsLocationSpecificStatus stat = it.next();
            if (locationMonitor.getId() != stat.getLocationMonitor().getId() || monSvc.getId() != stat.getMonitoredService().getId()) continue;
            return stat;
        }
        return null;
    }

    public Collection<OnmsLocationSpecificStatus> getAllMostRecentStatusChanges() {
        return this.getMostRecentStatusChangesInCollection(this.m_statuses);
    }

    private Collection<OnmsLocationSpecificStatus> getMostRecentStatusChangesInCollection(Collection<OnmsLocationSpecificStatus> sourceStatuses) {
        LinkedHashSet<StatusState> states = new LinkedHashSet<StatusState>();
        for (OnmsLocationSpecificStatus status : sourceStatuses) {
            StatusState state = new StatusState(status);
            states.add(state);
        }
        ArrayList<OnmsLocationSpecificStatus> statuses = new ArrayList<OnmsLocationSpecificStatus>();
        for (StatusState state : states) {
            statuses.add(state.getStatus());
        }
        return statuses;
    }

    public Collection<OnmsLocationSpecificStatus> getAllStatusChangesAt(Date timestamp) {
        return this.getMostRecentStatusChangesInCollection(this.getStatusChangesBetween(new Date(0L), timestamp));
    }

    public Collection<OnmsLocationSpecificStatus> getStatusChangesBetween(Date startDate, Date endDate) {
        ArrayList<OnmsLocationSpecificStatus> statuses = new ArrayList<OnmsLocationSpecificStatus>();
        for (OnmsLocationSpecificStatus status : this.m_statuses) {
            Date timestamp = status.getPollResult().getTimestamp();
            if (timestamp.getTime() != startDate.getTime() && !timestamp.after(startDate) || !timestamp.before(endDate)) continue;
            statuses.add(status);
        }
        return statuses;
    }

    public Collection<OnmsLocationSpecificStatus> getStatusChangesForLocationBetween(Date startDate, Date endDate, String locationDefinitionName) {
        ArrayList<OnmsLocationSpecificStatus> statuses = new ArrayList<OnmsLocationSpecificStatus>();
        for (OnmsLocationSpecificStatus status : this.getStatusChangesBetween(startDate, endDate)) {
            if (!locationDefinitionName.equals(status.getLocationMonitor().getName())) continue;
            statuses.add(status);
        }
        return statuses;
    }

    public Collection<OnmsLocationSpecificStatus> getStatusChangesForApplicationBetween(Date startDate, Date endDate, String applicationName) {
        ArrayList<OnmsLocationSpecificStatus> statuses = new ArrayList<OnmsLocationSpecificStatus>();
        block0: for (OnmsLocationSpecificStatus status : this.getStatusChangesBetween(startDate, endDate)) {
            for (OnmsApplication app : status.getMonitoredService().getApplications()) {
                if (!applicationName.equals(app.getName())) continue;
                statuses.add(status);
                continue block0;
            }
        }
        return statuses;
    }

    public Collection<OnmsLocationSpecificStatus> getStatusChangesBetweenForApplications(Date startDate, Date endDate, Collection<String> applicationNames) {
        ArrayList<OnmsLocationSpecificStatus> statuses = new ArrayList<OnmsLocationSpecificStatus>();
        block0: for (OnmsLocationSpecificStatus status : this.getStatusChangesBetween(startDate, endDate)) {
            boolean added = false;
            for (OnmsApplication app : status.getMonitoredService().getApplications()) {
                for (String applicationName : applicationNames) {
                    if (!applicationName.equals(app.getName())) continue;
                    statuses.add(status);
                    added = true;
                    break;
                }
                if (!added) continue;
                continue block0;
            }
        }
        return statuses;
    }

    public Collection<OnmsLocationSpecificStatus> getMostRecentStatusChangesForLocation(String locationName) {
        ArrayList<OnmsLocationSpecificStatus> statuses = new ArrayList<OnmsLocationSpecificStatus>();
        for (OnmsLocationSpecificStatus status : this.getAllMostRecentStatusChanges()) {
            if (!locationName.equals(status.getLocationMonitor().getName())) continue;
            statuses.add(status);
        }
        return statuses;
    }

    public Collection<LocationMonitorIpInterface> findStatusChangesForNodeForUniqueMonitorAndInterface(int nodeId) {
        HashSet<LocationMonitorIpInterface> ifaces = new HashSet<LocationMonitorIpInterface>();
        for (OnmsLocationSpecificStatus status : this.m_statuses) {
            if (status.getMonitoredService().getNodeId() != nodeId) continue;
            ifaces.add(new LocationMonitorIpInterface(status.getLocationMonitor(), status.getMonitoredService().getIpInterface()));
        }
        return ifaces;
    }

    public void pauseAll() {
        for (OnmsLocationMonitor monitor : this.findAll()) {
            if (monitor.getStatus() == OnmsLocationMonitor.MonitorStatus.STOPPED) continue;
            monitor.setStatus(OnmsLocationMonitor.MonitorStatus.PAUSED);
        }
    }

    public void resumeAll() {
        for (OnmsLocationMonitor monitor : this.findAll()) {
            if (monitor.getStatus() != OnmsLocationMonitor.MonitorStatus.PAUSED) continue;
            monitor.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
        }
    }

    private static class StatusState {
        private final OnmsLocationSpecificStatus m_status;

        public StatusState(OnmsLocationSpecificStatus status) {
            Assert.notNull((Object)status);
            Assert.notNull((Object)status.getMonitoredService());
            Assert.notNull((Object)status.getMonitoredService().getId());
            Assert.notNull((Object)status.getLocationMonitor());
            Assert.notNull((Object)status.getLocationMonitor().getId());
            this.m_status = status;
        }

        public OnmsLocationSpecificStatus getStatus() {
            return this.m_status;
        }

        public int hashCode() {
            int prime = 17;
            int result = 1;
            result = 17 * result + this.getMonitoredServiceId().hashCode();
            result = 17 * result + this.getLocationMonitorId().hashCode();
            return result;
        }

        private String getLocationMonitorId() {
            return this.m_status.getLocationMonitor().getId();
        }

        private Integer getMonitoredServiceId() {
            return this.m_status.getMonitoredService().getId();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof StatusState)) {
                return false;
            }
            StatusState other = (StatusState)obj;
            if (this.getLocationMonitorId() == null ? other.getLocationMonitorId() != null : !this.getLocationMonitorId().equals(other.getLocationMonitorId())) {
                return false;
            }
            return !(this.getMonitoredServiceId() == null ? other.getMonitoredServiceId() != null : !this.getMonitoredServiceId().equals(other.getMonitoredServiceId()));
        }
    }
}

