/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.mock;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.mock.AbstractMockDao;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.SurveillanceStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockNodeDao
extends AbstractMockDao<OnmsNode, Integer>
implements NodeDao {
    private static final Logger LOG = LoggerFactory.getLogger(MockNodeDao.class);
    private AtomicInteger m_id = new AtomicInteger(0);

    @Override
    protected void generateId(OnmsNode node) {
        node.setId(Integer.valueOf(this.m_id.incrementAndGet()));
    }

    @Override
    protected Integer getId(OnmsNode node) {
        return node.getId();
    }

    @Override
    public void delete(OnmsNode node) {
        for (OnmsIpInterface iface : node.getIpInterfaces()) {
            this.getIpInterfaceDao().delete((Object)iface);
        }
        for (OnmsIpInterface iface : node.getSnmpInterfaces()) {
            this.getSnmpInterfaceDao().delete((Object)iface);
        }
        super.delete(node);
    }

    @Override
    public void update(OnmsNode node) {
        if (node == null) {
            return;
        }
        super.update(node);
        this.updateSubObjects(node);
    }

    @Override
    public Integer save(OnmsNode node) {
        if (node == null) {
            return null;
        }
        Integer retval = (Integer)super.save(node);
        this.updateSubObjects(node);
        return retval;
    }

    @Override
    public void flush() {
        super.flush();
        for (OnmsNode node : this.findAll()) {
            this.updateSubObjects(node);
        }
    }

    private void updateSubObjects(OnmsNode node) {
        OnmsNode dbNode;
        node.getAssetRecord().setNode(node);
        this.getAssetRecordDao().saveOrUpdate((Object)node.getAssetRecord());
        for (OnmsCategory cat : node.getCategories()) {
            this.getCategoryDao().saveOrUpdate((Object)cat);
        }
        OnmsNode onmsNode = dbNode = node.getId() == null ? null : (OnmsNode)this.get(node.getId());
        if (dbNode != null) {
            for (OnmsSnmpInterface iface : dbNode.getSnmpInterfaces()) {
                if (node.getSnmpInterfaces().contains(iface)) continue;
                this.getSnmpInterfaceDao().delete((Object)iface);
            }
            for (OnmsSnmpInterface iface : dbNode.getIpInterfaces()) {
                if (node.getIpInterfaces().contains(iface)) continue;
                this.getIpInterfaceDao().delete((Object)iface);
            }
        }
        for (OnmsSnmpInterface iface : node.getSnmpInterfaces()) {
            iface.setNode(node);
            this.getSnmpInterfaceDao().saveOrUpdate((Object)iface);
        }
        for (OnmsSnmpInterface iface : node.getIpInterfaces()) {
            iface.setNode(node);
            this.getIpInterfaceDao().saveOrUpdate((Object)iface);
        }
    }

    @Override
    public OnmsNode get(String lookupCriteria) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public String getLabelForId(Integer id) {
        OnmsNode node = (OnmsNode)this.get(id);
        return node == null ? null : node.getLabel();
    }

    public List<OnmsNode> findByLabel(String label) {
        ArrayList<OnmsNode> nodes = new ArrayList<OnmsNode>();
        for (OnmsNode node : this.findAll()) {
            if (!label.equals(node.getLabel())) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public OnmsNode getHierarchy(Integer id) {
        return (OnmsNode)this.get(id);
    }

    public Map<String, Integer> getForeignIdToNodeIdMap(String foreignSource) {
        HashMap<String, Integer> nodes = new HashMap<String, Integer>();
        for (OnmsNode node : this.findAll()) {
            if (!foreignSource.equals(node.getForeignSource())) continue;
            nodes.put(node.getForeignId(), node.getId());
        }
        return nodes;
    }

    public List<OnmsNode> findAllByVarCharAssetColumn(String columnName, String columnValue) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsNode.class);
        builder.alias("assetRecord", "assets");
        builder.eq("assets." + columnName, (Object)columnValue);
        return this.findMatching(builder.toCriteria());
    }

    public List<OnmsNode> findAllByVarCharAssetColumnCategoryList(String columnName, String columnValue, Collection<OnmsCategory> categories) {
        ArrayList<OnmsNode> nodes = new ArrayList<OnmsNode>();
        block0: for (OnmsNode node : this.findAllByVarCharAssetColumn(columnName, columnValue)) {
            for (OnmsCategory cat : categories) {
                if (!node.hasCategory(cat.getName())) continue;
                nodes.add(node);
                continue block0;
            }
        }
        return nodes;
    }

    public List<OnmsNode> findByCategory(OnmsCategory category) {
        ArrayList<OnmsNode> nodes = new ArrayList<OnmsNode>();
        for (OnmsNode node : this.findAll()) {
            if (!node.getCategories().contains(category)) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public List<OnmsNode> findAllByCategoryList(Collection<OnmsCategory> categories) {
        ArrayList<OnmsNode> nodes = new ArrayList<OnmsNode>();
        for (OnmsNode node : this.findAll()) {
            for (OnmsCategory category : categories) {
                if (!node.getCategories().contains(category)) continue;
                nodes.add(node);
            }
        }
        return nodes;
    }

    public List<OnmsNode> findAllByCategoryLists(Collection<OnmsCategory> rowCatNames, Collection<OnmsCategory> colCatNames) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public List<OnmsNode> findByForeignSource(String foreignSource) {
        ArrayList<OnmsNode> nodes = new ArrayList<OnmsNode>();
        for (OnmsNode node : this.findAll()) {
            if (!Objects.equals(foreignSource, node.getForeignSource())) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public List<OnmsNode> findByIpAddressAndService(InetAddress ipAddress, String serviceName) {
        return null;
    }

    public OnmsNode findByForeignId(String foreignSource, String foreignId) {
        for (OnmsNode node : this.findByForeignSource(foreignSource)) {
            if (!foreignId.equals(node.getForeignId())) continue;
            return node;
        }
        return null;
    }

    public int getNodeCountForForeignSource(String foreignSource) {
        return this.findByForeignSource(foreignSource).size();
    }

    public Map<String, Set<String>> getForeignIdsPerForeignSourceMap() {
        TreeMap<String, Set<String>> map = new TreeMap<String, Set<String>>();
        for (OnmsNode node : this.findAll()) {
            if (node.getForeignSource() == null) continue;
            String foreignSource = node.getForeignSource();
            String foreignId = node.getForeignId();
            if (!map.containsKey(foreignSource)) {
                map.put(foreignSource, new TreeSet());
            }
            ((Set)map.get(foreignSource)).add(foreignId);
        }
        return map;
    }

    public Set<String> getForeignIdsPerForeignSource(String foreignSource) {
        TreeSet<String> set = new TreeSet<String>();
        for (OnmsNode node : this.findAll()) {
            if (node.getForeignId() == null) continue;
            set.add(node.getForeignId());
        }
        return set;
    }

    public List<OnmsNode> findAllProvisionedNodes() {
        ArrayList<OnmsNode> nodes = new ArrayList<OnmsNode>();
        for (OnmsNode node : this.findAll()) {
            if (node.getForeignSource() == null) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public List<OnmsIpInterface> findObsoleteIpInterfaces(Integer nodeId, Date scanStamp) {
        ArrayList<OnmsIpInterface> ifaces = new ArrayList<OnmsIpInterface>();
        OnmsNode node = (OnmsNode)this.get(nodeId);
        if (node == null) {
            return ifaces;
        }
        for (OnmsIpInterface iface : node.getIpInterfaces()) {
            if (iface.isPrimary() || MockNodeDao.truncateMillis(iface.getIpLastCapsdPoll()) >= MockNodeDao.truncateMillis(scanStamp)) continue;
            LOG.debug("findObsoleteIpInterfaces: {} < {}", (Object)MockNodeDao.truncateMillis(iface.getIpLastCapsdPoll()), (Object)MockNodeDao.truncateMillis(scanStamp));
            ifaces.add(iface);
        }
        return ifaces;
    }

    public List<OnmsSnmpInterface> findObsoleteSnmpInterfaces(Integer nodeId, Date scanStamp) {
        ArrayList<OnmsSnmpInterface> ifaces = new ArrayList<OnmsSnmpInterface>();
        OnmsNode node = (OnmsNode)this.get(nodeId);
        if (node == null) {
            return ifaces;
        }
        for (OnmsSnmpInterface iface : node.getSnmpInterfaces()) {
            if (MockNodeDao.truncateMillis(iface.getLastCapsdPoll()) >= MockNodeDao.truncateMillis(scanStamp)) continue;
            LOG.debug("findObsoleteSnmpInterfaces: {} < {}", (Object)MockNodeDao.truncateMillis(iface.getLastCapsdPoll()), (Object)MockNodeDao.truncateMillis(scanStamp));
            ifaces.add(iface);
        }
        return ifaces;
    }

    private static long truncateMillis(Date date) {
        return date == null ? 0L : 1000L * (date.getTime() / 1000L);
    }

    public void deleteObsoleteInterfaces(Integer nodeId, Date scanStamp) {
        OnmsNode node = (OnmsNode)this.get(nodeId);
        if (node == null) {
            return;
        }
        for (OnmsIpInterface onmsIpInterface : this.findObsoleteIpInterfaces(nodeId, scanStamp)) {
            LOG.debug("Deleting obsolete IP interface: {}", (Object)onmsIpInterface);
            node.getIpInterfaces().remove(onmsIpInterface);
            this.getIpInterfaceDao().delete((Serializable)onmsIpInterface.getId());
        }
        for (OnmsSnmpInterface onmsSnmpInterface : this.findObsoleteSnmpInterfaces(nodeId, scanStamp)) {
            LOG.debug("Deleting obsolete SNMP interface: {}", (Object)onmsSnmpInterface);
            node.getSnmpInterfaces().remove(onmsSnmpInterface);
            this.getSnmpInterfaceDao().delete((Serializable)onmsSnmpInterface.getId());
        }
    }

    public void updateNodeScanStamp(Integer nodeId, Date scanStamp) {
        ((OnmsNode)this.get(nodeId)).setLastCapsdPoll(scanStamp);
    }

    public Collection<Integer> getNodeIds() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (OnmsNode node : this.findAll()) {
            ids.add(node.getId());
        }
        return ids;
    }

    public List<OnmsNode> findByForeignSourceAndIpAddress(String foreignSource, String ipAddress) {
        ArrayList<OnmsNode> nodes = new ArrayList<OnmsNode>();
        for (OnmsNode node : this.findAll()) {
            OnmsIpInterface iface;
            if (!Objects.equals(foreignSource, node.getForeignSource()) || (iface = node.getIpInterfaceByIpAddress(ipAddress)) == null) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public SurveillanceStatus findSurveillanceStatusByCategoryLists(Collection<OnmsCategory> rowCategories, Collection<OnmsCategory> columnCategories) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public Integer getNextNodeId(Integer nodeId) {
        Integer next = null;
        for (OnmsNode node : this.findAll()) {
            if (node.getId() <= nodeId || next != null && node.getId() >= next) continue;
            next = node.getId();
        }
        return next;
    }

    public Integer getPreviousNodeId(Integer nodeId) {
        Integer previous = null;
        for (OnmsNode node : this.findAll()) {
            if (node.getId() >= nodeId || previous != null && previous >= node.getId()) continue;
            previous = node.getId();
        }
        return previous;
    }

    public Map<Integer, String> getAllLabelsById() {
        HashMap<Integer, String> allLabelsById = new HashMap<Integer, String>();
        for (OnmsNode node : this.findAll()) {
            allLabelsById.put(node.getId(), node.getLabel());
        }
        return allLabelsById;
    }

    public Map<String, Long> getNumberOfNodesBySysOid() {
        return new HashMap<String, Long>();
    }

    public int getNextNodeId() {
        return this.m_id.get() + 1;
    }
}

