/*******************************************************************************
 * This file is part of OpenNMS(R).
 *
 * Copyright (C) 2014 The OpenNMS Group, Inc.
 * OpenNMS(R) is Copyright (C) 1999-2014 The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * OpenNMS(R) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OpenNMS(R).  If not, see:
 *      http://www.gnu.org/licenses/
 *
 * For more information contact:
 *     OpenNMS(R) Licensing <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 *******************************************************************************/

package org.opennms.netmgt.dao.api;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;

public interface PathOutageManager {

	/** Constant <code>NO_CRITICAL_PATH="Not Configured"</code> */
	static final String NO_CRITICAL_PATH = "Not Configured";

	List<String[]> getAllCriticalPaths() throws SQLException;

	String getPrettyCriticalPath(int nodeID) throws SQLException;

	CriticalPath getCriticalPath(int nodeId);

	Set<Integer> getNodesInPath(String criticalPathIp, String criticalPathServiceName) throws SQLException;

	String[] getLabelAndStatus(String nodeIDStr, Connection conn) throws SQLException;

	String[] getCriticalPathData(String criticalPathIp, String criticalPathServiceName) throws SQLException;

	/**
	 * This method is used when you are scheduling an outage for an interface so that you can have
	 * the choice of also extending the outage to all nodes that are dependent on that interface for
	 * connectivity.
	 * 
	 * @param criticalpathip IP address of the interface whose outages would affect other nodes
	 * @return List of node IDs that would be impacted by an outage on the specified interface
	 * @throws SQLException
	 */
	Set<Integer> getAllNodesDependentOnAnyServiceOnInterface(String criticalpathip) throws SQLException;

	/**
	 * This method is used when you are scheduling an outage for an entire node so that you can have
	 * the choice of also extending the outage to all nodes that are dependent on that node for
	 * connectivity.
	 * 
	 * @param nodeId ID of the node whose outages would affect other nodes
	 * @return List of node IDs that would be impacted by an outage on the specified node
	 * @throws SQLException
	 */
	Set<Integer> getAllNodesDependentOnAnyServiceOnNode(int nodeId) throws SQLException;

	InetAddress getDefaultCriticalPathIp();
}
