/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.api;

import java.net.InetAddress;
import java.util.Date;
import java.util.Objects;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSeverity;

public class ApplicationStatusEntity {
    private final int serviceTypeId;
    private final int nodeId;
    private final InetAddress ipAddress;
    private final Date lastEventTime;
    private final OnmsSeverity severity;
    private long alarmCount;

    public ApplicationStatusEntity(Integer nodeId, InetAddress ipAddress, Integer serviceTypeId, Date lastEventTime, OnmsSeverity severity, Long alarmCount) {
        this.nodeId = nodeId;
        this.ipAddress = ipAddress;
        this.lastEventTime = lastEventTime;
        this.severity = severity;
        this.alarmCount = alarmCount;
        this.serviceTypeId = serviceTypeId;
    }

    public Key getKey() {
        return new Key(String.valueOf(this.nodeId), String.valueOf(this.serviceTypeId), this.ipAddress.toString());
    }

    public OnmsSeverity getSeverity() {
        return this.severity;
    }

    public int getCount() {
        return (int)this.alarmCount;
    }

    public static class Key {
        private final String nodeId;
        private final String serviceId;
        private final String ipAddress;

        public Key(String nodeId, String serviceId, String ipAddress) {
            this.nodeId = nodeId;
            this.serviceId = serviceId;
            this.ipAddress = ipAddress;
        }

        public Key(Integer nodeId, OnmsServiceType serviceType, InetAddress ipAddress) {
            this(String.valueOf(Objects.requireNonNull(nodeId)), String.valueOf(Objects.requireNonNull(serviceType).getId()), Objects.requireNonNull(ipAddress).toString());
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            boolean equals = Objects.equals(this.nodeId, other.nodeId) && Objects.equals(this.serviceId, other.serviceId) && Objects.equals(this.ipAddress, other.ipAddress);
            return equals;
        }

        public int hashCode() {
            return Objects.hash(this.nodeId, this.serviceId, this.ipAddress);
        }
    }
}

