/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.correlation;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.correlation.CorrelationEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;

public class CorrelationEngineFactoryBean
implements FactoryBean<List<CorrelationEngine>>,
InitializingBean,
ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(CorrelationEngineFactoryBean.class);
    private List<CorrelationEngine> m_correlationEngines = Collections.emptyList();
    private ApplicationContext m_applicationContext;

    public List<CorrelationEngine> getObject() throws Exception {
        return this.m_correlationEngines;
    }

    public Class<?> getObjectType() {
        return this.m_correlationEngines.getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_applicationContext != null ? 1 : 0) != 0, (String)"applicationContext must be set");
        Map<String, CorrelationEngine> beans = this.getBeans();
        LOG.debug("Deduplicating engines");
        HashSet<CorrelationEngine> engineSet = new HashSet<CorrelationEngine>(beans.values());
        this.m_correlationEngines = new LinkedList<CorrelationEngine>(engineSet);
        LOG.debug("Found {} engines.", (Object)this.m_correlationEngines.size());
    }

    private Map<String, CorrelationEngine> getBeans() {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.m_applicationContext, CorrelationEngine.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.m_applicationContext = applicationContext;
    }
}

