/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.correlation;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractSequentialList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class SoftReferenceList<T>
extends AbstractSequentialList<T> {
    private final List<SoftReference<T>> m_contents = new LinkedList<SoftReference<T>>();
    private final ReferenceQueue<T> queue = new ReferenceQueue();

    @Override
    public ListIterator<T> listIterator(int index) {
        this.processQueue();
        return new SoftReferenceListIterator(this.m_contents.listIterator(index), this.queue);
    }

    public void removeCollected() {
        this.processQueue();
        Iterator<SoftReference<T>> iter = this.m_contents.iterator();
        while (iter.hasNext()) {
            SoftReference<T> ref = iter.next();
            if (ref.get() != null) continue;
            iter.remove();
        }
    }

    private void processQueue() {
        Reference<T> ref;
        HashSet<Reference<T>> removed = new HashSet<Reference<T>>();
        while ((ref = this.queue.poll()) != null) {
            removed.add(ref);
        }
        this.m_contents.removeAll(removed);
    }

    @Override
    public int size() {
        this.processQueue();
        return this.m_contents.size();
    }

    private static class SoftReferenceListIterator<E>
    implements ListIterator<E> {
        final ListIterator<SoftReference<E>> m_it;
        final ReferenceQueue<E> m_queue;

        public SoftReferenceListIterator(ListIterator<SoftReference<E>> it, ReferenceQueue<E> queue) {
            this.m_it = it;
            this.m_queue = queue;
        }

        @Override
        public void add(E o) {
            this.assertNotNull(o);
            this.m_it.add(this.createRef(o));
        }

        @Override
        public boolean hasNext() {
            return this.m_it.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.m_it.hasPrevious();
        }

        @Override
        public E next() {
            SoftReference<E> ref = this.m_it.next();
            return ref.get();
        }

        @Override
        public int nextIndex() {
            return this.m_it.nextIndex();
        }

        @Override
        public E previous() {
            SoftReference<E> ref = this.m_it.previous();
            return ref.get();
        }

        @Override
        public int previousIndex() {
            return this.m_it.previousIndex();
        }

        @Override
        public void remove() {
            this.m_it.remove();
        }

        @Override
        public void set(E o) {
            this.assertNotNull(o);
            this.m_it.set(this.createRef(o));
        }

        private SoftReference<E> createRef(E element) {
            return new SoftReference<E>(element, this.m_queue);
        }

        private void assertNotNull(E o) {
            if (o == null) {
                throw new NullPointerException("null cannot be added to SoftReferenceLists");
            }
        }
    }
}

