/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.correlation;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.correlation.CorrelationEngine;
import org.opennms.netmgt.correlation.CorrelationEngineRegistrar;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class Correlator
extends AbstractServiceDaemon
implements CorrelationEngineRegistrar {
    private static final Logger LOG = LoggerFactory.getLogger(Correlator.class);
    private EventIpcManager m_eventIpcManager;
    private Map<String, CorrelationEngine> m_engines = new HashMap<String, CorrelationEngine>();
    private final List<EngineAdapter> m_adapters = new LinkedList<EngineAdapter>();
    private boolean m_initialized = false;

    protected Correlator() {
        super("correlator");
    }

    protected void onInit() {
        Assert.notNull((Object)this.m_eventIpcManager, (String)"property eventIpcManager must be set");
        Assert.notNull(this.m_engines, (String)"property engines must be set");
        for (CorrelationEngine engine : this.m_engines.values()) {
            LOG.info("Registering correlation engine: {}", (Object)engine);
            this.m_adapters.add(new EngineAdapter(engine));
        }
        this.m_initialized = true;
    }

    public void setCorrelationEngines(Collection<CorrelationEngine> engines) {
        this.m_engines.clear();
        engines.stream().forEach(engine -> this.m_engines.put(engine.getName(), (CorrelationEngine)engine));
    }

    public void setEventIpcManager(EventIpcManager eventIpcManager) {
        this.m_eventIpcManager = eventIpcManager;
    }

    @Override
    public void addCorrelationEngine(CorrelationEngine engine) {
        this.m_engines.put(engine.getName(), engine);
        if (this.m_initialized) {
            this.m_adapters.add(new EngineAdapter(engine));
        }
    }

    @Override
    public void addCorrelationEngines(CorrelationEngine ... engines) {
        for (CorrelationEngine engine : engines) {
            this.addCorrelationEngine(engine);
        }
    }

    @Override
    public CorrelationEngine findEngineByName(String name) {
        return this.m_engines.get(name);
    }

    @Override
    public Collection<CorrelationEngine> getEngines() {
        return this.m_engines.values();
    }

    private class EngineAdapter
    implements EventListener {
        private final String m_name;
        private final CorrelationEngine m_engine;

        public EngineAdapter(CorrelationEngine engine) {
            this.m_engine = engine;
            this.m_name = this.m_engine.getClass().getSimpleName() + '-' + this.m_engine.getName();
            Map mdc = Logging.getCopyOfContextMap();
            Logging.putPrefix((String)this.m_name);
            Correlator.this.m_eventIpcManager.addEventListener((EventListener)this, this.m_engine.getInterestingEvents());
            Logging.setContextMap((Map)mdc);
        }

        public String getName() {
            return this.m_name;
        }

        public void onEvent(Event e) {
            this.m_engine.correlate(e);
        }
    }
}

