/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.correlation;

import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.opennms.netmgt.correlation.CorrelationEngine;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.xml.event.Event;

public abstract class AbstractCorrelationEngine
implements CorrelationEngine {
    private static final AtomicInteger s_lastTimerId = new AtomicInteger(0);
    private EventIpcManager m_eventIpcManager;
    private ScheduledExecutorService m_scheduler;
    private final Map<Integer, ScheduledFuture<?>> m_pendingTasks = new ConcurrentHashMap();

    @Override
    public abstract void correlate(Event var1);

    @Override
    public abstract List<String> getInterestingEvents();

    public void setEventIpcManager(EventIpcManager eventIpcManager) {
        this.m_eventIpcManager = eventIpcManager;
    }

    public void sendEvent(Event e) {
        this.m_eventIpcManager.sendNow(e);
    }

    public Integer setTimer(long millis) {
        RuleTimerTask timerTask = new RuleTimerTask();
        ScheduledFuture<?> future = this.m_scheduler.schedule(timerTask, millis, TimeUnit.MILLISECONDS);
        this.m_pendingTasks.put(timerTask.getId(), future);
        return timerTask.getId();
    }

    public void cancelTimer(Integer timerId) {
        ScheduledFuture<?> task = this.m_pendingTasks.remove(timerId);
        if (task != null) {
            task.cancel(true);
        }
    }

    public int getPendingTasksCount() {
        return this.m_pendingTasks.size();
    }

    protected abstract void timerExpired(Integer var1);

    public void setScheduler(ScheduledExecutorService scheduler) {
        this.m_scheduler = scheduler;
    }

    protected void runTimer(RuleTimerTask task) {
        this.m_pendingTasks.remove(task.getId());
        this.timerExpired(task.getId());
    }

    static /* synthetic */ AtomicInteger access$000() {
        return s_lastTimerId;
    }

    private class RuleTimerTask
    extends TimerTask {
        private final Integer m_id = AbstractCorrelationEngine.access$000().incrementAndGet();

        public Integer getId() {
            return this.m_id;
        }

        @Override
        public void run() {
            AbstractCorrelationEngine.this.runTimer(this);
        }
    }
}

