/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.correlation;

import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.opennms.netmgt.correlation.CorrelationEngine;
import org.opennms.netmgt.model.events.EventIpcManager;
import org.opennms.netmgt.xml.event.Event;

public abstract class AbstractCorrelationEngine
implements CorrelationEngine {
    private static final AtomicInteger s_lastTimerId = new AtomicInteger(0);
    private EventIpcManager m_eventIpcManager;
    private Timer m_scheduler;
    private final Map<Integer, TimerTask> m_pendingTasks = new ConcurrentHashMap<Integer, TimerTask>();

    @Override
    public abstract void correlate(Event var1);

    @Override
    public abstract List<String> getInterestingEvents();

    public void setEventIpcManager(EventIpcManager eventIpcManager) {
        this.m_eventIpcManager = eventIpcManager;
    }

    public void sendEvent(Event e) {
        this.m_eventIpcManager.sendNow(e);
    }

    public Integer setTimer(long millis) {
        RuleTimerTask task = this.getTimerTask();
        this.m_scheduler.schedule((TimerTask)task, millis);
        return task.getId();
    }

    public RuleTimerTask getTimerTask() {
        RuleTimerTask timerTask = new RuleTimerTask();
        this.m_pendingTasks.put(timerTask.getId(), timerTask);
        return timerTask;
    }

    public void cancelTimer(Integer timerId) {
        TimerTask task = this.m_pendingTasks.remove(timerId);
        if (task != null) {
            task.cancel();
        }
    }

    protected abstract void timerExpired(Integer var1);

    public void setScheduler(Timer scheduler) {
        this.m_scheduler = scheduler;
    }

    public void runTimer(RuleTimerTask task) {
        this.m_pendingTasks.remove(task.getId());
        this.timerExpired(task.getId());
    }

    static /* synthetic */ AtomicInteger access$000() {
        return s_lastTimerId;
    }

    private class RuleTimerTask
    extends TimerTask {
        private final Integer m_id = AbstractCorrelationEngine.access$000().incrementAndGet();

        public Integer getId() {
            return this.m_id;
        }

        @Override
        public void run() {
            AbstractCorrelationEngine.this.runTimer(this);
        }
    }
}

