/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.opennms.netmgt.config.api.PathOutageConfig;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.PollerConfiguration;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.model.ServiceSelector;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.ServiceMonitorLocator;
import org.opennms.netmgt.poller.ServiceMonitorRegistry;

public interface PollerConfig
extends PathOutageConfig {
    public String getCriticalService();

    public boolean shouldPollAllIfNoCriticalServiceDefined();

    public boolean isNodeOutageProcessingEnabled();

    public boolean isServiceUnresponsiveEnabled();

    public void rebuildPackageIpListMap();

    public Iterable<Parameter> parameters(Service var1);

    public List<InetAddress> getIpList(Package var1);

    public boolean isInterfaceInPackage(String var1, Package var2);

    public boolean isServiceInPackageAndEnabled(String var1, Package var2);

    public Service getServiceInPackage(String var1, Package var2);

    public boolean isServiceMonitored(String var1);

    public Package getFirstPackageMatch(String var1);

    public Package getFirstLocalPackageMatch(String var1);

    public boolean isPolled(String var1);

    public boolean isPolledLocally(String var1);

    public boolean isPolled(String var1, Package var2);

    public boolean isPolled(String var1, String var2);

    public boolean isPolledLocally(String var1, String var2);

    public int getStep(Package var1);

    public List<String> getRRAList(Package var1);

    public List<String> getAllPackageMatches(String var1);

    public String getNextOutageIdSql();

    public Enumeration<Package> enumeratePackage();

    public Package getPackage(String var1);

    public ServiceSelector getServiceSelectorForPackage(Package var1);

    public int getThreads();

    public Set<String> getServiceMonitorNames();

    public ServiceMonitor getServiceMonitor(String var1);

    public void update() throws IOException;

    public void save() throws IOException;

    public void addPackage(Package var1);

    public void addMonitor(String var1, String var2);

    public PollerConfiguration getConfiguration();

    public Collection<ServiceMonitorLocator> getServiceMonitorLocators(DistributionContext var1);

    public ServiceMonitorRegistry getServiceMonitorRegistry();

    public Lock getReadLock();

    public Lock getWriteLock();

    default public Package findPackageForService(String ipAddr, String serviceName) {
        Enumeration<Package> en = this.enumeratePackage();
        Package lastPkg = null;
        while (en.hasMoreElements()) {
            Package pkg = en.nextElement();
            if (!this.pollableServiceInPackage(ipAddr, serviceName, pkg)) continue;
            lastPkg = pkg;
        }
        return lastPkg;
    }

    default public boolean pollableServiceInPackage(String ipAddr, String serviceName, Package pkg) {
        if (pkg.getRemote().booleanValue()) {
            return false;
        }
        if (!this.isServiceInPackageAndEnabled(serviceName, pkg)) {
            return false;
        }
        boolean inPkg = this.isInterfaceInPackage(ipAddr, pkg);
        if (inPkg) {
            return true;
        }
        this.rebuildPackageIpListMap();
        return this.isInterfaceInPackage(ipAddr, pkg);
    }
}

