/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.threshd.Basethresholddef;
import org.opennms.netmgt.config.threshd.Group;
import org.opennms.netmgt.config.threshd.Threshold;
import org.opennms.netmgt.config.threshd.ThresholdingConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThresholdingConfigFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ThresholdingConfigFactory.class);
    private static ThresholdingConfigFactory m_singleton = null;
    private ThresholdingConfig m_config;
    private static boolean m_loaded = false;
    private Map<String, Group> m_groupMap;

    private ThresholdingConfigFactory(String configFile) throws IOException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(configFile);
            this.parseXML(stream);
        }
        finally {
            if (stream != null) {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
    }

    public ThresholdingConfigFactory(InputStream stream) throws IOException {
        this.parseXML(stream);
    }

    private void parseXML(InputStream stream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(stream);){
            this.m_config = (ThresholdingConfig)JaxbUtils.unmarshal(ThresholdingConfig.class, (Reader)reader);
        }
        this.initGroupMap();
    }

    private void initGroupMap() {
        HashMap<String, Group> groupMap = new HashMap<String, Group>();
        for (Group g : this.m_config.getGroups()) {
            groupMap.put(g.getName(), g);
        }
        this.m_groupMap = groupMap;
    }

    public static synchronized void init() throws IOException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.THRESHOLDING_CONF_FILE_NAME);
        LOG.debug("init: config file path: {}", (Object)cfgFile.getPath());
        ThresholdingConfigFactory tcf = new ThresholdingConfigFactory(cfgFile.getPath());
        for (String groupName : tcf.getGroupNames()) {
            Group g = tcf.getGroup(groupName);
            for (Threshold threshold : g.getThresholds()) {
                if (threshold.getDsName().length() <= 19) continue;
                throw new IllegalStateException(String.format("ds-name '%s' in group '%s' is greater than %d characters", threshold.getDsName(), groupName, 19));
            }
        }
        m_singleton = tcf;
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException {
        m_singleton = null;
        m_loaded = false;
        ThresholdingConfigFactory.init();
    }

    public static synchronized ThresholdingConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(ThresholdingConfigFactory instance) {
        m_loaded = true;
        m_singleton = instance;
    }

    public String getRrdRepository(String groupName) {
        return this.getGroup(groupName).getRrdRepository();
    }

    public Group getGroup(String groupName) {
        Group group = this.m_groupMap.get(groupName);
        if (group == null) {
            throw new IllegalArgumentException("Thresholding group " + groupName + " does not exist.");
        }
        return group;
    }

    public Collection<Basethresholddef> getThresholds(String groupName) {
        Group group = this.getGroup(groupName);
        ArrayList<Basethresholddef> result = new ArrayList<Basethresholddef>();
        result.addAll(group.getThresholds());
        result.addAll(group.getExpressions());
        return result;
    }

    public Collection<String> getGroupNames() {
        return Collections.unmodifiableCollection(this.m_groupMap.keySet());
    }

    public synchronized void saveCurrent() throws IOException {
        String xmlString = JaxbUtils.marshal((Object)this.m_config);
        if (xmlString != null) {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.THRESHOLDING_CONF_FILE_NAME);
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(cfgFile), StandardCharsets.UTF_8);
            fileWriter.write(xmlString);
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
            this.update();
        }
    }

    public void update() throws IOException {
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.THRESHOLDING_CONF_FILE_NAME);
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(cfgFile);
            this.parseXML(stream);
        }
        finally {
            if (stream != null) {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
    }
}

