/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.Serializable;
import org.opennms.netmgt.config.ConfigObjectRetrievalFailureException;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.ServiceMonitorLocator;
import org.opennms.netmgt.poller.ServiceMonitorRegistry;

public class DefaultServiceMonitorLocator
implements ServiceMonitorLocator,
Serializable {
    private static final long serialVersionUID = 1L;
    String m_serviceName;
    Class<? extends ServiceMonitor> m_serviceClass;

    public DefaultServiceMonitorLocator(String serviceName, Class<? extends ServiceMonitor> serviceClass) {
        this.m_serviceName = serviceName;
        this.m_serviceClass = serviceClass;
    }

    public ServiceMonitor getServiceMonitor(ServiceMonitorRegistry registry) {
        ServiceMonitor sm = registry.getMonitorByClassName(this.m_serviceClass.getCanonicalName());
        if (sm == null) {
            throw new ConfigObjectRetrievalFailureException("Could not find monitor for service " + this.m_serviceName + " with class-name " + this.m_serviceClass.getName(), null);
        }
        return sm;
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public String getServiceLocatorKey() {
        return this.m_serviceClass.getName();
    }
}

