/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.IOException;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.netmgt.config.DefaultDataCollectionConfigDao;
import org.opennms.netmgt.config.api.DataCollectionConfigDao;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public abstract class DataCollectionConfigFactory {
    private static DataCollectionConfigDao m_singleton = null;

    public static void setInstance(DataCollectionConfigDao instance) {
        m_singleton = instance;
    }

    public static synchronized void init() throws IOException {
        if (m_singleton == null) {
            m_singleton = (DataCollectionConfigDao)BeanUtils.getBean((String)"daoContext", (String)"dataCollectionConfigDao", DataCollectionConfigDao.class);
        }
    }

    public static synchronized void reload() throws IOException {
        if (m_singleton == null) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        m_singleton.reload();
    }

    public static synchronized DataCollectionConfigDao getInstance() {
        if (m_singleton == null) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static void main(String[] args) {
        try {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.DATA_COLLECTION_CONF_FILE_NAME);
            DefaultDataCollectionConfigDao config = new DefaultDataCollectionConfigDao();
            config.setConfigResource((Resource)new FileSystemResource(cfgFile));
            config.afterPropertiesSet();
            config.getConfiguredResourceTypes();
            System.out.println("OK: no errors found");
        }
        catch (Throwable e) {
            System.err.println("ERROR: " + e.getMessage());
        }
    }
}

