/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.kscReports.Report;
import org.opennms.netmgt.config.kscReports.ReportsList;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class KSC_PerformanceReportFactory {
    private static KSC_PerformanceReportFactory s_instance = null;
    private static File s_configFile = null;
    private ReportsList m_config;
    public static final String[] TIMESPAN_OPTIONS = new String[]{"1_hour", "2_hour", "4_hour", "6_hour", "8_hour", "12_hour", "1_day", "2_day", "7_day", "1_month", "3_month", "6_month", "1_year", "Today", "Yesterday", "Yesterday 9am-5pm", "Yesterday 5pm-10pm", "This Week", "Last Week", "This Month", "Last Month", "This Quarter", "Last Quarter", "This Year", "Last Year"};
    private Map<Integer, Report> m_reportList;

    private KSC_PerformanceReportFactory() {
    }

    public static synchronized void init() throws IOException, FileNotFoundException {
        if (KSC_PerformanceReportFactory.isInitialized()) {
            return;
        }
        KSC_PerformanceReportFactory newInstance = new KSC_PerformanceReportFactory();
        newInstance.reload();
        s_instance = newInstance;
    }

    public static synchronized KSC_PerformanceReportFactory getInstance() throws IllegalStateException {
        KSC_PerformanceReportFactory.assertInitialized();
        return s_instance;
    }

    public synchronized void reload() throws IOException, FileNotFoundException {
        if (s_configFile == null) {
            s_configFile = ConfigFileConstants.getFile((int)ConfigFileConstants.KSC_REPORT_FILE_NAME);
        }
        this.m_config = (ReportsList)JaxbUtils.unmarshal(ReportsList.class, (Resource)new FileSystemResource(s_configFile));
        this.setIdsOnAllReports();
        this.m_reportList = this.createReportList();
    }

    public static void setConfigFile(File configFile) {
        s_configFile = configFile;
    }

    private void setIdsOnAllReports() {
        int i = 0;
        for (Report report : this.m_config.getReports()) {
            if (report.getId() == null || (Integer)report.getId().get() < i) continue;
            i = (Integer)report.getId().get() + 1;
        }
        for (Report report : this.m_config.getReports()) {
            if (report.getId() != null) continue;
            report.setId(Integer.valueOf(i));
            ++i;
        }
    }

    public synchronized void saveCurrent() throws IOException, FileNotFoundException {
        KSC_PerformanceReportFactory.assertInitialized();
        this.m_config.sort();
        JaxbUtils.marshal((Object)this.m_config, (File)s_configFile);
        this.reload();
    }

    private static void assertInitialized() {
        Assert.state((boolean)KSC_PerformanceReportFactory.isInitialized(), (String)"KSC_PerformanceReportFactory.init() has not been called");
    }

    private static boolean isInitialized() {
        return s_instance != null;
    }

    public Report getReportByIndex(int index) {
        return this.m_reportList.get(index);
    }

    private Map<Integer, Report> createReportList() {
        LinkedHashMap<Integer, Report> reports = new LinkedHashMap<Integer, Report>(this.m_config.getReports().size());
        for (Report report : this.m_config.getReports()) {
            if (reports.containsKey(report.getId())) {
                throw new IllegalArgumentException("Report id " + report.getId() + " is used by multiple reports in configuration file");
            }
            reports.put((Integer)report.getId().get(), report);
        }
        return reports;
    }

    public Map<Integer, String> getReportList() {
        LinkedHashMap reports = new LinkedHashMap(this.m_config.getReports().size());
        List reportList = this.m_config.getReports();
        Collections.sort(reportList, new Comparator<Report>(){

            @Override
            public int compare(Report o1, Report o2) {
                return o1.getTitle().compareTo(o2.getTitle());
            }
        });
        for (Report report : reportList) {
            reports.put(report.getId().get(), report.getTitle());
        }
        return Collections.unmodifiableMap(reports);
    }

    public Map<Integer, Report> getReportMap() {
        HashMap reports = new HashMap(this.m_config.getReports().size());
        for (Report report : this.m_config.getReports()) {
            reports.put(report.getId().get(), report);
        }
        return Collections.unmodifiableMap(reports);
    }

    public void deleteReportAndSave(int index) throws ArrayIndexOutOfBoundsException, IOException, FileNotFoundException {
        Report report = this.getReportByIndex(index);
        if (report == null) {
            throw new ArrayIndexOutOfBoundsException("Reports List index to be deleted is out of bounds: " + index);
        }
        this.m_config.removeReport(report);
        this.saveCurrent();
    }

    public void addReport(Report report) {
        this.m_config.addReport(report);
        this.setIdsOnAllReports();
    }

    public void setReport(int index, Report report) {
        int arrayIndex = this.getArrayIndex(index);
        if (arrayIndex == -1) {
            throw new IllegalArgumentException("Could not find report with ID of " + index);
        }
        int index1 = arrayIndex;
        if (((Report)this.m_config.getReports().get(index1)).getId() != null) {
            int index2 = arrayIndex;
            report.setId((Integer)((Report)this.m_config.getReports().get(index2)).getId().orElse(null));
        }
        this.m_config.setReport(arrayIndex, report);
        this.setIdsOnAllReports();
    }

    private int getArrayIndex(int index) {
        int i = 0;
        for (Report report : this.m_config.getReports()) {
            if (report.getId().isPresent() && (Integer)report.getId().get() == index) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static synchronized void getBeginEndTime(String interval, Calendar begin_time, Calendar end_time) throws IllegalArgumentException {
        if (interval.equals("1_hour")) {
            begin_time.add(10, -1);
        } else if (interval.equals("2_hour")) {
            begin_time.add(10, -2);
        } else if (interval.equals("4_hour")) {
            begin_time.add(10, -4);
        } else if (interval.equals("6_hour")) {
            begin_time.add(10, -6);
        } else if (interval.equals("8_hour")) {
            begin_time.add(10, -8);
        } else if (interval.equals("12_hour")) {
            begin_time.add(10, -12);
        } else if (interval.equals("1_day")) {
            begin_time.add(5, -1);
        } else if (interval.equals("2_day")) {
            begin_time.add(5, -2);
        } else if (interval.equals("7_day")) {
            begin_time.add(5, -7);
        } else if (interval.equals("1_month")) {
            begin_time.add(5, -30);
        } else if (interval.equals("3_month")) {
            begin_time.add(5, -90);
        } else if (interval.equals("6_month")) {
            begin_time.add(5, -183);
        } else if (interval.equals("1_year")) {
            begin_time.add(5, -365);
        } else {
            begin_time.set(11, 0);
            begin_time.set(12, 0);
            begin_time.set(13, 0);
            end_time.set(11, 0);
            end_time.set(12, 0);
            end_time.set(13, 0);
            if (interval.equals("Today")) {
                end_time.add(5, 1);
            } else if (interval.equals("Yesterday")) {
                begin_time.add(5, -1);
            } else if (interval.equals("Yesterday 9am-5pm")) {
                begin_time.add(5, -1);
                begin_time.set(11, 9);
                end_time.add(5, -1);
                end_time.set(11, 17);
            } else if (interval.equals("Yesterday 5pm-10pm")) {
                begin_time.add(5, -1);
                begin_time.set(11, 17);
                end_time.add(5, -1);
                end_time.set(11, 22);
            } else if (interval.equals("This Week") || interval.equals("Last Week")) {
                begin_time.set(7, begin_time.getFirstDayOfWeek());
                end_time.set(7, end_time.getFirstDayOfWeek());
                end_time.add(5, 6);
                end_time.set(11, 23);
                end_time.set(12, 59);
                if (interval.equals("Last Week")) {
                    begin_time.add(5, -7);
                    end_time.add(5, -7);
                }
            } else if (interval.equals("This Month")) {
                begin_time.set(5, 1);
                end_time.add(2, 1);
                end_time.set(5, 1);
            } else if (interval.equals("Last Month")) {
                begin_time.add(2, -1);
                begin_time.set(5, 1);
                end_time.set(5, 1);
            } else if (interval.equals("This Quarter") || interval.equals("Last Quarter")) {
                begin_time.set(5, 1);
                end_time.set(5, 1);
                switch (begin_time.get(2)) {
                    case 0: 
                    case 1: 
                    case 2: {
                        begin_time.set(2, 0);
                        end_time.set(2, 3);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        begin_time.set(2, 3);
                        end_time.set(2, 6);
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        begin_time.set(2, 6);
                        end_time.set(2, 9);
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        begin_time.set(2, 9);
                        end_time.set(2, 0);
                        end_time.add(1, 1);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid Calendar Month " + begin_time.get(2));
                    }
                }
                if (interval.equals("Last Quarter")) {
                    begin_time.add(2, -3);
                    end_time.add(2, -3);
                }
            } else if (interval.equals("This Year")) {
                begin_time.set(2, 0);
                begin_time.set(5, 1);
                end_time.set(2, 0);
                end_time.set(5, 1);
                end_time.add(1, 1);
            } else if (interval.equals("Last Year")) {
                begin_time.set(2, 0);
                begin_time.set(5, 1);
                begin_time.add(1, -1);
                end_time.set(2, 0);
                end_time.set(5, 1);
            } else {
                throw new IllegalArgumentException("Unknown graph timespan: " + interval);
            }
        }
    }
}

