/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.opennms.core.utils.OwnedInterval;
import org.opennms.core.utils.OwnedIntervalSequence;
import org.opennms.core.utils.Owner;
import org.opennms.netmgt.config.CalendarEntry;
import org.opennms.netmgt.config.GroupManager;
import org.opennms.netmgt.config.WebRolesException;
import org.opennms.netmgt.config.groups.Role;

public class Day {
    private final Calendar m_calendar;
    private final Role m_role;
    private final GroupManager m_groupManager;

    public Day(Date date, Role role, GroupManager groupManager) {
        this.m_role = role;
        this.m_groupManager = groupManager;
        this.m_calendar = Calendar.getInstance();
        this.m_calendar.setTime(date);
    }

    public Date getDate() {
        return this.m_calendar.getTime();
    }

    public int getMonth() {
        return this.m_calendar.get(2);
    }

    public int getDayOfMonth() {
        return this.m_calendar.get(5);
    }

    public int getDayOfYear() {
        return this.m_calendar.get(6);
    }

    public String getDayOfWeek() {
        return new SimpleDateFormat("EEEE").format(this.m_calendar.getTime());
    }

    public Date getTime(int hours, int minutes) {
        Calendar time = Calendar.getInstance();
        time.set(this.m_calendar.get(1), this.m_calendar.get(2), this.m_calendar.get(5), hours, minutes);
        return time.getTime();
    }

    public CalendarEntry[] getEntries() {
        try {
            ArrayList<CalendarEntry> entries = new ArrayList<CalendarEntry>();
            OwnedIntervalSequence schedEntries = this.m_groupManager.getRoleScheduleEntries(this.m_role.getName(), this.getTime(0, 0), this.getTime(24, 0));
            for (OwnedInterval schedEntry : schedEntries) {
                CalendarEntry entry = new CalendarEntry(schedEntry.getStart(), schedEntry.getEnd(), this.ownerString(schedEntry.getOwners()), schedEntry.getOwners());
                entries.add(entry);
            }
            return entries.toArray(new CalendarEntry[entries.size()]);
        }
        catch (Throwable e) {
            throw new WebRolesException("Unable to get schedule entries: " + e.getMessage(), e);
        }
    }

    private String ownerString(List<Owner> owners) {
        boolean first = true;
        StringBuffer buf = new StringBuffer();
        for (Owner owner : owners) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(owner.getUser());
        }
        return buf.toString();
    }
}

