/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.Serializable;
import java.util.Map;
import org.opennms.netmgt.config.ConfigObjectRetrievalFailureException;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.ServiceMonitorLocator;

public class DefaultServiceMonitorLocator
implements ServiceMonitorLocator,
Serializable {
    private static final long serialVersionUID = 1L;
    String m_serviceName;
    Class<? extends ServiceMonitor> m_serviceClass;

    public DefaultServiceMonitorLocator(String serviceName, Class<? extends ServiceMonitor> serviceClass) {
        this.m_serviceName = serviceName;
        this.m_serviceClass = serviceClass;
    }

    public ServiceMonitor getServiceMonitor() {
        try {
            ServiceMonitor mon = this.m_serviceClass.newInstance();
            mon.initialize((Map)null);
            return mon;
        }
        catch (InstantiationException e) {
            throw new ConfigObjectRetrievalFailureException("Unable to instantiate monitor for service " + this.m_serviceName + " with class-name " + this.m_serviceClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigObjectRetrievalFailureException("Illegal access trying to instantiate monitor for service " + this.m_serviceName + " with class-name " + this.m_serviceClass.getName(), e);
        }
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public String getServiceLocatorKey() {
        return this.m_serviceClass.getName();
    }
}

