/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.wmi.WmiCollection;
import org.opennms.netmgt.config.wmi.WmiDatacollectionConfig;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WmiDataCollectionConfigFactory {
    private static final Logger LOG = LoggerFactory.getLogger(WmiDataCollectionConfigFactory.class);
    private static WmiDataCollectionConfigFactory m_instance;
    private static boolean m_loadedFromFile;
    protected boolean initialized = false;
    protected static long m_lastModified;
    private static WmiDatacollectionConfig m_config;

    public WmiDataCollectionConfigFactory(String configFile) throws MarshalException, ValidationException, IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(configFile);
            this.initialize(is);
        }
        finally {
            if (is != null) {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
    }

    public WmiDataCollectionConfigFactory(InputStream is) throws MarshalException, ValidationException {
        this.initialize(is);
    }

    private void initialize(InputStream stream) throws MarshalException, ValidationException {
        LOG.debug("initialize: initializing WMI collection config factory.");
        m_config = (WmiDatacollectionConfig)CastorUtils.unmarshal(WmiDatacollectionConfig.class, (InputStream)stream);
    }

    public static synchronized void init() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        if (m_instance == null) {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.WMI_COLLECTION_CONFIG_FILE_NAME);
            m_instance = new WmiDataCollectionConfigFactory(cfgFile.getPath());
            m_lastModified = cfgFile.lastModified();
            m_loadedFromFile = true;
        }
    }

    public static synchronized WmiDataCollectionConfigFactory getInstance() {
        if (m_instance == null) {
            throw new IllegalStateException("You must call WmiCollectionConfigFactory.init() before calling getInstance().");
        }
        return m_instance;
    }

    public static synchronized void setInstance(WmiDataCollectionConfigFactory instance) {
        m_instance = instance;
        m_loadedFromFile = false;
    }

    public synchronized void reload() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        m_instance = null;
        WmiDataCollectionConfigFactory.init();
    }

    protected void updateFromFile() throws IOException, MarshalException, ValidationException {
        File surveillanceViewsFile;
        if (m_loadedFromFile && m_lastModified != (surveillanceViewsFile = ConfigFileConstants.getFile((int)ConfigFileConstants.WMI_COLLECTION_CONFIG_FILE_NAME)).lastModified()) {
            this.reload();
        }
    }

    public static synchronized WmiDatacollectionConfig getConfig() {
        return m_config;
    }

    public static synchronized void setConfig(WmiDatacollectionConfig m_config) {
        WmiDataCollectionConfigFactory.m_config = m_config;
    }

    public WmiCollection getWmiCollection(String collectionName) {
        WmiCollection coll;
        WmiCollection[] collections = m_config.getWmiCollection();
        WmiCollection collection = null;
        int n = 0;
        WmiCollection[] wmiCollectionArray = collections;
        int n2 = wmiCollectionArray.length;
        if (n < n2 && (coll = wmiCollectionArray[n]).getName().equalsIgnoreCase(collectionName)) {
            collection = coll;
        }
        if (collection == null) {
            throw new IllegalArgumentException("getWmiCollection: collection name: " + collectionName + " specified in collectd configuration not found in WMI collection configuration.");
        }
        return collection;
    }

    public RrdRepository getRrdRepository(String collectionName) {
        RrdRepository repo = new RrdRepository();
        repo.setRrdBaseDir(new File(this.getRrdPath()));
        repo.setRraList(this.getRRAList(collectionName));
        repo.setStep(this.getStep(collectionName));
        repo.setHeartBeat(2 * this.getStep(collectionName));
        return repo;
    }

    public int getStep(String cName) {
        WmiCollection collection = this.getWmiCollection(cName);
        if (collection != null) {
            return collection.getRrd().getStep();
        }
        return -1;
    }

    public List<String> getRRAList(String cName) {
        WmiCollection collection = this.getWmiCollection(cName);
        if (collection != null) {
            return collection.getRrd().getRraCollection();
        }
        return null;
    }

    public String getRrdPath() {
        String rrdPath = m_config.getRrdRepository();
        if (rrdPath == null) {
            throw new RuntimeException("Configuration error, failed to retrieve path to RRD repository.");
        }
        if (rrdPath.endsWith(File.separator)) {
            rrdPath = rrdPath.substring(0, rrdPath.length() - File.separator.length());
        }
        return rrdPath;
    }

    static {
        m_loadedFromFile = false;
    }
}

