/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.BeanInfo;
import org.opennms.netmgt.config.JMXDataCollectionConfigDao;
import org.opennms.netmgt.config.collectd.jmx.Attrib;
import org.opennms.netmgt.config.collectd.jmx.CompAttrib;
import org.opennms.netmgt.config.collectd.jmx.CompMember;
import org.opennms.netmgt.config.collectd.jmx.JmxCollection;
import org.opennms.netmgt.config.collectd.jmx.JmxDatacollectionConfig;
import org.opennms.netmgt.config.collectd.jmx.Mbean;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public final class JMXDataCollectionConfigFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JMXDataCollectionConfigFactory.class);
    private static JMXDataCollectionConfigFactory m_singleton = null;
    private JmxDatacollectionConfig m_config;
    private static boolean m_loaded = false;
    private Map<String, JmxCollection> m_collectionMap;

    public JMXDataCollectionConfigFactory(InputStream stream) {
        this.initialize((Resource)new InputStreamResource(stream));
    }

    private JMXDataCollectionConfigFactory(String configFile) throws IOException {
        this.initialize((Resource)new FileSystemResource(configFile));
    }

    private void initialize(Resource resource) {
        JMXDataCollectionConfigDao dao = new JMXDataCollectionConfigDao();
        dao.setConfigResource(resource);
        dao.afterPropertiesSet();
        this.m_config = dao.getConfig();
        this.buildCollectionMap();
    }

    private void buildCollectionMap() {
        this.m_collectionMap = new HashMap<String, JmxCollection>();
        HashMap collectionGroupMap = new HashMap();
        for (JmxCollection collection : this.m_config.getJmxCollectionList()) {
            HashMap<String, Mbean> groupMap = new HashMap<String, Mbean>();
            for (Mbean mbean : collection.getMbeans()) {
                groupMap.put(mbean.getName(), mbean);
            }
            collectionGroupMap.put(collection.getName(), groupMap);
            this.m_collectionMap.put(collection.getName(), collection);
        }
    }

    public static synchronized void init() throws IOException {
        if (m_loaded) {
            return;
        }
        try {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.JMX_DATA_COLLECTION_CONF_FILE_NAME);
            LOG.debug("init: config file path: {}", (Object)cfgFile.getPath());
            m_singleton = new JMXDataCollectionConfigFactory(cfgFile.getPath());
        }
        catch (IOException ioe) {
            LOG.error("Unable to open JMX data collection config file", (Throwable)ioe);
            throw ioe;
        }
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException {
        m_singleton = null;
        m_loaded = false;
        JMXDataCollectionConfigFactory.init();
    }

    public static synchronized JMXDataCollectionConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(JMXDataCollectionConfigFactory singleton) {
        m_singleton = singleton;
        m_loaded = true;
    }

    public Map<String, List<Attrib>> getAttributeMap(String cName, String aSysoid, String anAddress) {
        HashMap<String, List<Attrib>> attributeMap = new HashMap<String, List<Attrib>>();
        LOG.debug("getMibObjectList: collection: {} sysoid: {} address: {}", new Object[]{anAddress, cName, aSysoid});
        if (aSysoid == null) {
            LOG.debug("getMibObjectList: aSysoid parameter is NULL...");
            return attributeMap;
        }
        JmxCollection collection = this.m_collectionMap.get(cName);
        if (collection == null) {
            return attributeMap;
        }
        for (Mbean mbean : collection.getMbeans()) {
            ArrayList<Attrib> list = new ArrayList<Attrib>(mbean.getAttribList());
            for (CompAttrib compAttrib : mbean.getCompAttribList()) {
                for (CompMember compMember : compAttrib.getCompMemberList()) {
                    Attrib attribWrapper = new Attrib();
                    attribWrapper.setName(compAttrib.getName() + "|" + compMember.getName());
                    attribWrapper.setAlias(compMember.getAlias());
                    attribWrapper.setType(compMember.getType());
                    list.add(attribWrapper);
                }
            }
            attributeMap.put(mbean.getObjectname(), list);
        }
        return attributeMap;
    }

    public JmxCollection getJmxCollection(String collectionName) {
        JmxCollection collection = this.m_collectionMap.get(collectionName);
        if (collection != null) {
            StringWriter out = new StringWriter();
            JaxbUtils.marshal((Object)collection, (Writer)out);
            StringReader in = new StringReader(out.toString());
            JmxCollection clonedCollection = (JmxCollection)JaxbUtils.unmarshal(JmxCollection.class, (Reader)in);
            return clonedCollection;
        }
        LOG.warn("No JMX Config for collection '{}' found", (Object)collectionName);
        return null;
    }

    public Map<String, BeanInfo> getMBeanInfo(String cName) {
        HashMap<String, BeanInfo> map = new HashMap<String, BeanInfo>();
        JmxCollection collection = this.m_collectionMap.get(cName);
        if (collection == null) {
            LOG.warn("no collection named '{}' was found", (Object)cName);
        } else {
            for (Mbean mbean : collection.getMbeans()) {
                BeanInfo beanInfo = new BeanInfo();
                beanInfo.setMbeanName(mbean.getName());
                beanInfo.setObjectName(mbean.getObjectname());
                beanInfo.setKeyField(mbean.getKeyfield());
                beanInfo.setExcludes(mbean.getExclude());
                beanInfo.setKeyAlias(mbean.getKeyAlias());
                ArrayList<String> attribNameList = new ArrayList<String>();
                ArrayList<String> compAttribNameList = new ArrayList<String>();
                for (CompAttrib myCa : mbean.getCompAttribList()) {
                    for (CompMember myCm : myCa.getCompMemberList()) {
                        attribNameList.add(myCa.getName() + "|" + myCm.getName());
                        compAttribNameList.add(myCa.getName() + "|" + myCm.getName());
                    }
                }
                for (Attrib myA : mbean.getAttribList()) {
                    attribNameList.add(myA.getName());
                }
                beanInfo.setAttributes(attribNameList);
                beanInfo.setCompositeAttributes(compAttribNameList);
                map.put(mbean.getObjectname(), beanInfo);
            }
        }
        return Collections.unmodifiableMap(map);
    }

    public int getStep(String cName) {
        JmxCollection collection = this.m_collectionMap.get(cName);
        if (collection != null) {
            return collection.getRrd().getStep();
        }
        return -1;
    }

    public List<String> getRRAList(String cName) {
        JmxCollection collection = this.m_collectionMap.get(cName);
        if (collection != null) {
            return collection.getRrd().getRraCollection();
        }
        return null;
    }

    public RrdRepository getRrdRepository(String collectionName) {
        RrdRepository repo = new RrdRepository();
        repo.setRrdBaseDir(new File(this.getRrdPath()));
        repo.setRraList(this.getRRAList(collectionName));
        repo.setStep(this.getStep(collectionName));
        repo.setHeartBeat(2 * this.getStep(collectionName));
        return repo;
    }

    public String getRrdPath() {
        String rrdPath = this.m_config.getRrdRepository();
        if (rrdPath == null) {
            throw new RuntimeException("Configuration error, failed to retrieve path to RRD repository.");
        }
        if (rrdPath.endsWith(File.separator)) {
            rrdPath = rrdPath.substring(0, rrdPath.length() - File.separator.length());
        }
        return rrdPath;
    }
}

