/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.AbstractJaxbConfigDao;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.collectd.jmx.JmxCollection;
import org.opennms.netmgt.config.collectd.jmx.JmxDatacollectionConfig;
import org.opennms.netmgt.config.collectd.jmx.Mbeans;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class JMXDataCollectionConfigDao
extends AbstractJaxbConfigDao<JmxDatacollectionConfig, JmxDatacollectionConfig> {
    public static final Logger LOG = LoggerFactory.getLogger(JMXDataCollectionConfigDao.class);

    public JMXDataCollectionConfigDao() {
        super(JmxDatacollectionConfig.class, "jmx-data-collection");
    }

    protected JmxDatacollectionConfig translateConfig(JmxDatacollectionConfig config) {
        for (JmxCollection collection : config.getJmxCollectionList()) {
            if (!collection.hasImportMbeans()) continue;
            for (String importMbeans : collection.getImportGroupsList()) {
                File file = new File(ConfigFileConstants.getHome(), "/etc/" + importMbeans);
                LOG.debug("parseJmxMbeans: parsing {}", (Object)file);
                Mbeans mbeans = (Mbeans)JaxbUtils.unmarshal(Mbeans.class, (Resource)new FileSystemResource(file));
                collection.addMbeans(mbeans.getMbeanList());
            }
        }
        return config;
    }

    public JmxDatacollectionConfig getConfig() {
        return (JmxDatacollectionConfig)this.getContainer().getObject();
    }
}

