/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.LinkdConfigManager;
import org.opennms.netmgt.config.linkd.LinkdConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LinkdConfigFactory
extends LinkdConfigManager {
    private static final Logger LOG = LoggerFactory.getLogger(LinkdConfigFactory.class);

    public LinkdConfigFactory() throws MarshalException, ValidationException, IOException {
        this.reload();
    }

    public LinkdConfigFactory(InputStream stream) throws MarshalException, ValidationException, IOException {
        this.reloadXML(stream);
    }

    @Override
    protected synchronized void saveXml(String xml) throws IOException {
        if (xml != null) {
            long timestamp = System.currentTimeMillis();
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.LINKD_CONFIG_FILE_NAME);
            LOG.debug("saveXml: saving config file at {}: {}", (Object)timestamp, (Object)cfgFile.getPath());
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(cfgFile), "UTF-8");
            fileWriter.write(xml);
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
            LOG.debug("saveXml: finished saving config file: {}", (Object)cfgFile.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() throws IOException, MarshalException, ValidationException {
        this.getWriteLock().lock();
        try {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.LINKD_CONFIG_FILE_NAME);
            LOG.debug("init: config file path: {}", (Object)cfgFile.getPath());
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(cfgFile);
                this.reloadXML(stream);
            }
            finally {
                if (stream != null) {
                    IOUtils.closeQuietly((InputStream)stream);
                }
            }
            LOG.debug("init: finished loading config file: {}", (Object)cfgFile.getPath());
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    @Override
    public void update() {
        this.getWriteLock().lock();
        try {
            this.updateUrlIpMap();
            this.updatePackageIpListMap();
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    protected void reloadXML(InputStream stream) throws MarshalException, ValidationException, IOException {
        this.getWriteLock().lock();
        try {
            m_config = (LinkdConfiguration)CastorUtils.unmarshal(LinkdConfiguration.class, (InputStream)stream);
            this.updateUrlIpMap();
            this.updatePackageIpListMap();
            this.updateVlanClassNames();
            this.updateIpRouteClassNames();
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    @Override
    public void save() throws MarshalException, IOException, ValidationException {
        this.getWriteLock().lock();
        try {
            StringWriter stringWriter = new StringWriter();
            Marshaller.marshal((Object)m_config, (Writer)stringWriter);
            this.saveXml(stringWriter.toString());
        }
        finally {
            this.getWriteLock().unlock();
        }
    }
}

