/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.xmlrpcd.ExternalServers;
import org.opennms.netmgt.config.xmlrpcd.SubscribedEvent;
import org.opennms.netmgt.config.xmlrpcd.Subscription;
import org.opennms.netmgt.config.xmlrpcd.XmlrpcdConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XmlrpcdConfigFactory {
    private static final Logger LOG = LoggerFactory.getLogger(XmlrpcdConfigFactory.class);
    private static XmlrpcdConfigFactory m_singleton = null;
    private static boolean m_loaded = false;
    private XmlrpcdConfiguration m_config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlrpcdConfigFactory(String configFile) throws IOException, MarshalException, ValidationException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(configFile);
            this.unmarshal(is);
        }
        finally {
            if (is != null) {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
    }

    public XmlrpcdConfigFactory(Reader rdr) throws IOException, MarshalException, ValidationException {
        this.unmarshal(rdr);
    }

    public XmlrpcdConfigFactory(InputStream stream) throws MarshalException, ValidationException {
        this.unmarshal(stream);
    }

    @Deprecated
    private void unmarshal(Reader rdr) throws MarshalException, ValidationException {
        this.m_config = (XmlrpcdConfiguration)CastorUtils.unmarshal(XmlrpcdConfiguration.class, (Reader)rdr);
        this.handleLegacyConfiguration();
    }

    private void unmarshal(InputStream stream) throws MarshalException, ValidationException {
        this.m_config = (XmlrpcdConfiguration)CastorUtils.unmarshal(XmlrpcdConfiguration.class, (InputStream)stream);
        this.handleLegacyConfiguration();
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.XMLRPCD_CONFIG_FILE_NAME);
        XmlrpcdConfigFactory.init(cfgFile);
    }

    public static synchronized void init(File cfgFile) throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        LOG.debug("init: config file path: {}", (Object)cfgFile.getPath());
        XmlrpcdConfigFactory.setInstance(new XmlrpcdConfigFactory(cfgFile.getPath()));
    }

    private void handleLegacyConfiguration() {
        String generatedSubscriptionName = null;
        Enumeration<ExternalServers> e = this.getExternalServerEnumeration();
        while (e.hasMoreElements()) {
            ExternalServers es = e.nextElement();
            if (es.getServerSubscriptionCollection().size() != 0) continue;
            if (generatedSubscriptionName == null) {
                generatedSubscriptionName = "legacyServerSubscription-" + UUID.randomUUID().toString();
            }
            es.addServerSubscription(generatedSubscriptionName);
        }
        if (generatedSubscriptionName != null) {
            boolean foundUnnamedSubscription = false;
            for (Subscription s : this.getConfiguration().getSubscriptionCollection()) {
                if (s.getName() != null) continue;
                s.setName(generatedSubscriptionName);
                foundUnnamedSubscription = true;
                break;
            }
            if (!foundUnnamedSubscription) {
                String[] ueis = new String[]{"uei.opennms.org/nodes/nodeLostService", "uei.opennms.org/nodes/nodeRegainedService", "uei.opennms.org/nodes/nodeUp", "uei.opennms.org/nodes/nodeDown", "uei.opennms.org/nodes/interfaceUp", "uei.opennms.org/nodes/interfaceDown", "uei.opennms.org/internal/capsd/updateServer", "uei.opennms.org/internal/capsd/updateService", "uei.opennms.org/internal/capsd/xmlrpcNotification"};
                Subscription subscription = new Subscription();
                subscription.setName(generatedSubscriptionName);
                SubscribedEvent subscribedEvent = null;
                for (String uei : ueis) {
                    subscribedEvent = new SubscribedEvent();
                    subscribedEvent.setUei(uei);
                    subscription.addSubscribedEvent(subscribedEvent);
                }
                this.getConfiguration().addSubscription(subscription);
            }
        }
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        XmlrpcdConfigFactory.init();
    }

    public static synchronized XmlrpcdConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(XmlrpcdConfigFactory instance) {
        m_singleton = instance;
        m_loaded = true;
    }

    public synchronized XmlrpcdConfiguration getConfiguration() {
        return this.m_config;
    }

    public synchronized List<SubscribedEvent> getEventList(ExternalServers server) throws ValidationException {
        ArrayList<SubscribedEvent> allEventsList = new ArrayList<SubscribedEvent>();
        for (String name : server.getServerSubscriptionCollection()) {
            List subscriptions = this.m_config.getSubscriptionCollection();
            boolean foundSubscription = false;
            for (Subscription sub : subscriptions) {
                if (!sub.getName().equals(name)) continue;
                allEventsList.addAll(sub.getSubscribedEventCollection());
                foundSubscription = true;
                break;
            }
            if (foundSubscription) continue;
            LOG.error("serverSubscription element {} references a subscription that does not exist", (Object)name);
            throw new ValidationException("serverSubscription element " + name + " references a subscription that does not exist");
        }
        return allEventsList;
    }

    public synchronized Enumeration<ExternalServers> getExternalServerEnumeration() {
        return this.m_config.enumerateExternalServers();
    }

    public synchronized Enumeration<Subscription> getSubscriptionEnumeration() {
        return this.m_config.enumerateSubscription();
    }

    public synchronized Collection<ExternalServers> getExternalServerCollection() {
        return this.m_config.getExternalServersCollection();
    }

    public synchronized Collection<Subscription> getSubscriptionCollection() {
        return this.m_config.getSubscriptionCollection();
    }

    public synchronized int getMaxQueueSize() {
        return this.m_config.getMaxEventQueueSize();
    }
}

