/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.service.Service;
import org.opennms.netmgt.config.service.ServiceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceConfigFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceConfigFactory.class);
    private ServiceConfiguration m_config;

    public ServiceConfigFactory() {
        this.reload();
    }

    public synchronized void reload() {
        try {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SERVICE_CONF_FILE_NAME);
            LOG.debug("ServiceConfigFactory.init: config file path {}", (Object)cfgFile.getPath());
            this.m_config = (ServiceConfiguration)JaxbUtils.unmarshal(ServiceConfiguration.class, (File)cfgFile);
        }
        catch (IOException e) {
            LOG.error("Could not open configuration file: " + ConfigFileConstants.SERVICE_CONF_FILE_NAME, (Throwable)e);
        }
    }

    public Service[] getServices() {
        ArrayList<Service> services = new ArrayList<Service>();
        for (Service s : this.m_config.getServiceCollection()) {
            if (!s.isEnabled().booleanValue()) continue;
            services.add(s);
        }
        return services.toArray(new Service[services.size()]);
    }
}

