/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.netmgt.config.OpennmsServerConfigManager;

public final class OpennmsServerConfigFactory
extends OpennmsServerConfigManager {
    private static OpennmsServerConfigFactory m_singleton = null;
    private static boolean m_loaded = false;

    public OpennmsServerConfigFactory(InputStream is) {
        super(is);
    }

    public static synchronized void init() throws IOException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.OPENNMS_SERVER_CONFIG_FILE_NAME);
        FileInputStream cfgIn = new FileInputStream(cfgFile);
        m_singleton = new OpennmsServerConfigFactory(cfgIn);
        ((InputStream)cfgIn).close();
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException {
        m_singleton = null;
        m_loaded = false;
        OpennmsServerConfigFactory.init();
    }

    public static synchronized OpennmsServerConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(OpennmsServerConfigFactory instance) {
        m_singleton = instance;
        m_loaded = true;
    }
}

