/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opennms.netmgt.config.EnhancedLinkdConfig;
import org.opennms.netmgt.config.enlinkd.EnlinkdConfiguration;

public abstract class EnhancedLinkdConfigManager
implements EnhancedLinkdConfig {
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    protected static EnlinkdConfiguration m_config;

    @Override
    public Lock getReadLock() {
        return this.m_readLock;
    }

    @Override
    public Lock getWriteLock() {
        return this.m_writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnlinkdConfiguration getConfiguration() {
        this.getReadLock().lock();
        try {
            EnlinkdConfiguration enlinkdConfiguration = m_config;
            return enlinkdConfiguration;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public boolean useCdpDiscovery() {
        if (m_config.hasUseCdpDiscovery()) {
            return m_config.getUseCdpDiscovery();
        }
        return true;
    }

    @Override
    public boolean useBridgeDiscovery() {
        if (m_config.hasUseBridgeDiscovery()) {
            return m_config.getUseBridgeDiscovery();
        }
        return true;
    }

    @Override
    public boolean useLldpDiscovery() {
        if (m_config.hasUseLldpDiscovery()) {
            return m_config.getUseLldpDiscovery();
        }
        return true;
    }

    @Override
    public boolean useOspfDiscovery() {
        if (m_config.hasUseOspfDiscovery()) {
            return m_config.getUseOspfDiscovery();
        }
        return true;
    }

    @Override
    public boolean useIsisDiscovery() {
        if (m_config.hasUseIsisDiscovery()) {
            return m_config.getUseIsisDiscovery();
        }
        return true;
    }

    @Override
    public long getInitialSleepTime() {
        if (m_config.hasInitial_sleep_time()) {
            return m_config.getInitial_sleep_time();
        }
        return 1800000L;
    }

    @Override
    public long getRescanInterval() {
        if (m_config.hasRescan_interval()) {
            return m_config.getRescan_interval();
        }
        return 86400000L;
    }

    @Override
    public int getThreads() {
        if (m_config.hasThreads()) {
            return m_config.getThreads();
        }
        return 5;
    }

    protected abstract void saveXml(String var1) throws IOException;
}

