/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.vulnscand;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.vulnscand.Excludes;
import org.opennms.netmgt.config.vulnscand.ManagedInterfaces;
import org.opennms.netmgt.config.vulnscand.ScanLevel;
import org.xml.sax.ContentHandler;

public class VulnscandConfiguration
implements Serializable {
    private long _rescanFrequency;
    private boolean _has_rescanFrequency;
    private long _initialSleepTime;
    private boolean _has_initialSleepTime;
    private int _maxSuspectThreadPoolSize;
    private boolean _has_maxSuspectThreadPoolSize;
    private int _maxRescanThreadPoolSize;
    private boolean _has_maxRescanThreadPoolSize;
    private String _serverAddress;
    private int _serverPort;
    private boolean _has_serverPort;
    private String _serverUsername;
    private String _serverPassword;
    private boolean _status;
    private boolean _has_status;
    private ManagedInterfaces _managedInterfaces;
    private List<ScanLevel> _scanLevelList = new ArrayList<ScanLevel>();
    private Excludes _excludes;

    public void addScanLevel(ScanLevel vScanLevel) throws IndexOutOfBoundsException {
        if (this._scanLevelList.size() >= 4) {
            throw new IndexOutOfBoundsException("addScanLevel has a maximum of 4");
        }
        this._scanLevelList.add(vScanLevel);
    }

    public void addScanLevel(int index, ScanLevel vScanLevel) throws IndexOutOfBoundsException {
        if (this._scanLevelList.size() >= 4) {
            throw new IndexOutOfBoundsException("addScanLevel has a maximum of 4");
        }
        this._scanLevelList.add(index, vScanLevel);
    }

    public void deleteInitialSleepTime() {
        this._has_initialSleepTime = false;
    }

    public void deleteMaxRescanThreadPoolSize() {
        this._has_maxRescanThreadPoolSize = false;
    }

    public void deleteMaxSuspectThreadPoolSize() {
        this._has_maxSuspectThreadPoolSize = false;
    }

    public void deleteRescanFrequency() {
        this._has_rescanFrequency = false;
    }

    public void deleteServerPort() {
        this._has_serverPort = false;
    }

    public void deleteStatus() {
        this._has_status = false;
    }

    public Enumeration<ScanLevel> enumerateScanLevel() {
        return Collections.enumeration(this._scanLevelList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof VulnscandConfiguration) {
            VulnscandConfiguration temp = (VulnscandConfiguration)obj;
            if (this._rescanFrequency != temp._rescanFrequency) {
                return false;
            }
            if (this._has_rescanFrequency != temp._has_rescanFrequency) {
                return false;
            }
            if (this._initialSleepTime != temp._initialSleepTime) {
                return false;
            }
            if (this._has_initialSleepTime != temp._has_initialSleepTime) {
                return false;
            }
            if (this._maxSuspectThreadPoolSize != temp._maxSuspectThreadPoolSize) {
                return false;
            }
            if (this._has_maxSuspectThreadPoolSize != temp._has_maxSuspectThreadPoolSize) {
                return false;
            }
            if (this._maxRescanThreadPoolSize != temp._maxRescanThreadPoolSize) {
                return false;
            }
            if (this._has_maxRescanThreadPoolSize != temp._has_maxRescanThreadPoolSize) {
                return false;
            }
            if (this._serverAddress != null) {
                if (temp._serverAddress == null) {
                    return false;
                }
                if (!this._serverAddress.equals(temp._serverAddress)) {
                    return false;
                }
            } else if (temp._serverAddress != null) {
                return false;
            }
            if (this._serverPort != temp._serverPort) {
                return false;
            }
            if (this._has_serverPort != temp._has_serverPort) {
                return false;
            }
            if (this._serverUsername != null) {
                if (temp._serverUsername == null) {
                    return false;
                }
                if (!this._serverUsername.equals(temp._serverUsername)) {
                    return false;
                }
            } else if (temp._serverUsername != null) {
                return false;
            }
            if (this._serverPassword != null) {
                if (temp._serverPassword == null) {
                    return false;
                }
                if (!this._serverPassword.equals(temp._serverPassword)) {
                    return false;
                }
            } else if (temp._serverPassword != null) {
                return false;
            }
            if (this._status != temp._status) {
                return false;
            }
            if (this._has_status != temp._has_status) {
                return false;
            }
            if (this._managedInterfaces != null) {
                if (temp._managedInterfaces == null) {
                    return false;
                }
                if (!this._managedInterfaces.equals(temp._managedInterfaces)) {
                    return false;
                }
            } else if (temp._managedInterfaces != null) {
                return false;
            }
            if (this._scanLevelList != null) {
                if (temp._scanLevelList == null) {
                    return false;
                }
                if (!((Object)this._scanLevelList).equals(temp._scanLevelList)) {
                    return false;
                }
            } else if (temp._scanLevelList != null) {
                return false;
            }
            if (this._excludes != null) {
                if (temp._excludes == null) {
                    return false;
                }
                if (!this._excludes.equals(temp._excludes)) {
                    return false;
                }
            } else if (temp._excludes != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Excludes getExcludes() {
        return this._excludes;
    }

    public long getInitialSleepTime() {
        return this._initialSleepTime;
    }

    public ManagedInterfaces getManagedInterfaces() {
        return this._managedInterfaces;
    }

    public int getMaxRescanThreadPoolSize() {
        return this._maxRescanThreadPoolSize;
    }

    public int getMaxSuspectThreadPoolSize() {
        return this._maxSuspectThreadPoolSize;
    }

    public long getRescanFrequency() {
        return this._rescanFrequency;
    }

    public ScanLevel getScanLevel(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._scanLevelList.size()) {
            throw new IndexOutOfBoundsException("getScanLevel: Index value '" + index + "' not in range [0.." + (this._scanLevelList.size() - 1) + "]");
        }
        return this._scanLevelList.get(index);
    }

    public ScanLevel[] getScanLevel() {
        ScanLevel[] array = new ScanLevel[]{};
        return this._scanLevelList.toArray(array);
    }

    public List<ScanLevel> getScanLevelCollection() {
        return this._scanLevelList;
    }

    public int getScanLevelCount() {
        return this._scanLevelList.size();
    }

    public String getServerAddress() {
        return this._serverAddress;
    }

    public String getServerPassword() {
        return this._serverPassword;
    }

    public int getServerPort() {
        return this._serverPort;
    }

    public String getServerUsername() {
        return this._serverUsername;
    }

    public boolean getStatus() {
        return this._status;
    }

    public boolean hasInitialSleepTime() {
        return this._has_initialSleepTime;
    }

    public boolean hasMaxRescanThreadPoolSize() {
        return this._has_maxRescanThreadPoolSize;
    }

    public boolean hasMaxSuspectThreadPoolSize() {
        return this._has_maxSuspectThreadPoolSize;
    }

    public boolean hasRescanFrequency() {
        return this._has_rescanFrequency;
    }

    public boolean hasServerPort() {
        return this._has_serverPort;
    }

    public boolean hasStatus() {
        return this._has_status;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (int)(this._rescanFrequency ^ this._rescanFrequency >>> 32);
        result = 37 * result + (int)(this._initialSleepTime ^ this._initialSleepTime >>> 32);
        result = 37 * result + this._maxSuspectThreadPoolSize;
        result = 37 * result + this._maxRescanThreadPoolSize;
        if (this._serverAddress != null) {
            result = 37 * result + this._serverAddress.hashCode();
        }
        result = 37 * result + this._serverPort;
        if (this._serverUsername != null) {
            result = 37 * result + this._serverUsername.hashCode();
        }
        if (this._serverPassword != null) {
            result = 37 * result + this._serverPassword.hashCode();
        }
        result = 37 * result + (this._status ? 0 : 1);
        if (this._managedInterfaces != null) {
            result = 37 * result + this._managedInterfaces.hashCode();
        }
        if (this._scanLevelList != null) {
            result = 37 * result + ((Object)this._scanLevelList).hashCode();
        }
        if (this._excludes != null) {
            result = 37 * result + this._excludes.hashCode();
        }
        return result;
    }

    public boolean isStatus() {
        return this._status;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<ScanLevel> iterateScanLevel() {
        return this._scanLevelList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllScanLevel() {
        this._scanLevelList.clear();
    }

    public boolean removeScanLevel(ScanLevel vScanLevel) {
        boolean removed = this._scanLevelList.remove(vScanLevel);
        return removed;
    }

    public ScanLevel removeScanLevelAt(int index) {
        ScanLevel obj = this._scanLevelList.remove(index);
        return obj;
    }

    public void setExcludes(Excludes excludes) {
        this._excludes = excludes;
    }

    public void setInitialSleepTime(long initialSleepTime) {
        this._initialSleepTime = initialSleepTime;
        this._has_initialSleepTime = true;
    }

    public void setManagedInterfaces(ManagedInterfaces managedInterfaces) {
        this._managedInterfaces = managedInterfaces;
    }

    public void setMaxRescanThreadPoolSize(int maxRescanThreadPoolSize) {
        this._maxRescanThreadPoolSize = maxRescanThreadPoolSize;
        this._has_maxRescanThreadPoolSize = true;
    }

    public void setMaxSuspectThreadPoolSize(int maxSuspectThreadPoolSize) {
        this._maxSuspectThreadPoolSize = maxSuspectThreadPoolSize;
        this._has_maxSuspectThreadPoolSize = true;
    }

    public void setRescanFrequency(long rescanFrequency) {
        this._rescanFrequency = rescanFrequency;
        this._has_rescanFrequency = true;
    }

    public void setScanLevel(int index, ScanLevel vScanLevel) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._scanLevelList.size()) {
            throw new IndexOutOfBoundsException("setScanLevel: Index value '" + index + "' not in range [0.." + (this._scanLevelList.size() - 1) + "]");
        }
        this._scanLevelList.set(index, vScanLevel);
    }

    public void setScanLevel(ScanLevel[] vScanLevelArray) {
        this._scanLevelList.clear();
        for (int i = 0; i < vScanLevelArray.length; ++i) {
            this._scanLevelList.add(vScanLevelArray[i]);
        }
    }

    public void setScanLevel(List<ScanLevel> vScanLevelList) {
        this._scanLevelList.clear();
        this._scanLevelList.addAll(vScanLevelList);
    }

    public void setScanLevelCollection(List<ScanLevel> scanLevelList) {
        this._scanLevelList = scanLevelList;
    }

    public void setServerAddress(String serverAddress) {
        this._serverAddress = serverAddress;
    }

    public void setServerPassword(String serverPassword) {
        this._serverPassword = serverPassword;
    }

    public void setServerPort(int serverPort) {
        this._serverPort = serverPort;
        this._has_serverPort = true;
    }

    public void setServerUsername(String serverUsername) {
        this._serverUsername = serverUsername;
    }

    public void setStatus(boolean status) {
        this._status = status;
        this._has_status = true;
    }

    public static VulnscandConfiguration unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (VulnscandConfiguration)Unmarshaller.unmarshal(VulnscandConfiguration.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

