/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.pagesequence;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.pagesequence.Page;
import org.xml.sax.ContentHandler;

public class PageSequence
implements Serializable {
    private List<Page> _pageList = new ArrayList<Page>();

    public void addPage(Page vPage) throws IndexOutOfBoundsException {
        this._pageList.add(vPage);
    }

    public void addPage(int index, Page vPage) throws IndexOutOfBoundsException {
        this._pageList.add(index, vPage);
    }

    public Enumeration<Page> enumeratePage() {
        return Collections.enumeration(this._pageList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PageSequence) {
            PageSequence temp = (PageSequence)obj;
            if (this._pageList != null) {
                if (temp._pageList == null) {
                    return false;
                }
                if (!((Object)this._pageList).equals(temp._pageList)) {
                    return false;
                }
            } else if (temp._pageList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Page getPage(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._pageList.size()) {
            throw new IndexOutOfBoundsException("getPage: Index value '" + index + "' not in range [0.." + (this._pageList.size() - 1) + "]");
        }
        return this._pageList.get(index);
    }

    public Page[] getPage() {
        Page[] array = new Page[]{};
        return this._pageList.toArray(array);
    }

    public List<Page> getPageCollection() {
        return this._pageList;
    }

    public int getPageCount() {
        return this._pageList.size();
    }

    public int hashCode() {
        int result = 17;
        if (this._pageList != null) {
            result = 37 * result + ((Object)this._pageList).hashCode();
        }
        return result;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Page> iteratePage() {
        return this._pageList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllPage() {
        this._pageList.clear();
    }

    public boolean removePage(Page vPage) {
        boolean removed = this._pageList.remove(vPage);
        return removed;
    }

    public Page removePageAt(int index) {
        Page obj = this._pageList.remove(index);
        return obj;
    }

    public void setPage(int index, Page vPage) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._pageList.size()) {
            throw new IndexOutOfBoundsException("setPage: Index value '" + index + "' not in range [0.." + (this._pageList.size() - 1) + "]");
        }
        this._pageList.set(index, vPage);
    }

    public void setPage(Page[] vPageArray) {
        this._pageList.clear();
        for (int i = 0; i < vPageArray.length; ++i) {
            this._pageList.add(vPageArray[i]);
        }
    }

    public void setPage(List<Page> vPageList) {
        this._pageList.clear();
        this._pageList.addAll(vPageList);
    }

    public void setPageCollection(List<Page> pageList) {
        this._pageList = pageList;
    }

    public static PageSequence unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (PageSequence)Unmarshaller.unmarshal(PageSequence.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

