/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.map.adapter;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.map.adapter.Celement;
import org.opennms.netmgt.config.map.adapter.Csubmap;
import org.xml.sax.ContentHandler;

public class Cmap
implements Serializable {
    private String _mapName;
    private String _mapOwner;
    private String _mapGroup;
    private String _mapAccess;
    private String _mapBG = "ffffff";
    private int _mapWidth;
    private boolean _has_mapWidth;
    private int _mapHeight;
    private boolean _has_mapHeight;
    private List<Celement> _celementList;
    private List<Csubmap> _csubmapList;

    public Cmap() {
        this.setMapBG("ffffff");
        this._celementList = new ArrayList<Celement>();
        this._csubmapList = new ArrayList<Csubmap>();
    }

    public void addCelement(Celement vCelement) throws IndexOutOfBoundsException {
        this._celementList.add(vCelement);
    }

    public void addCelement(int index, Celement vCelement) throws IndexOutOfBoundsException {
        this._celementList.add(index, vCelement);
    }

    public void addCsubmap(Csubmap vCsubmap) throws IndexOutOfBoundsException {
        this._csubmapList.add(vCsubmap);
    }

    public void addCsubmap(int index, Csubmap vCsubmap) throws IndexOutOfBoundsException {
        this._csubmapList.add(index, vCsubmap);
    }

    public void deleteMapHeight() {
        this._has_mapHeight = false;
    }

    public void deleteMapWidth() {
        this._has_mapWidth = false;
    }

    public Enumeration<Celement> enumerateCelement() {
        return Collections.enumeration(this._celementList);
    }

    public Enumeration<Csubmap> enumerateCsubmap() {
        return Collections.enumeration(this._csubmapList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Cmap) {
            Cmap temp = (Cmap)obj;
            if (this._mapName != null) {
                if (temp._mapName == null) {
                    return false;
                }
                if (!this._mapName.equals(temp._mapName)) {
                    return false;
                }
            } else if (temp._mapName != null) {
                return false;
            }
            if (this._mapOwner != null) {
                if (temp._mapOwner == null) {
                    return false;
                }
                if (!this._mapOwner.equals(temp._mapOwner)) {
                    return false;
                }
            } else if (temp._mapOwner != null) {
                return false;
            }
            if (this._mapGroup != null) {
                if (temp._mapGroup == null) {
                    return false;
                }
                if (!this._mapGroup.equals(temp._mapGroup)) {
                    return false;
                }
            } else if (temp._mapGroup != null) {
                return false;
            }
            if (this._mapAccess != null) {
                if (temp._mapAccess == null) {
                    return false;
                }
                if (!this._mapAccess.equals(temp._mapAccess)) {
                    return false;
                }
            } else if (temp._mapAccess != null) {
                return false;
            }
            if (this._mapBG != null) {
                if (temp._mapBG == null) {
                    return false;
                }
                if (!this._mapBG.equals(temp._mapBG)) {
                    return false;
                }
            } else if (temp._mapBG != null) {
                return false;
            }
            if (this._mapWidth != temp._mapWidth) {
                return false;
            }
            if (this._has_mapWidth != temp._has_mapWidth) {
                return false;
            }
            if (this._mapHeight != temp._mapHeight) {
                return false;
            }
            if (this._has_mapHeight != temp._has_mapHeight) {
                return false;
            }
            if (this._celementList != null) {
                if (temp._celementList == null) {
                    return false;
                }
                if (!((Object)this._celementList).equals(temp._celementList)) {
                    return false;
                }
            } else if (temp._celementList != null) {
                return false;
            }
            if (this._csubmapList != null) {
                if (temp._csubmapList == null) {
                    return false;
                }
                if (!((Object)this._csubmapList).equals(temp._csubmapList)) {
                    return false;
                }
            } else if (temp._csubmapList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Celement getCelement(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._celementList.size()) {
            throw new IndexOutOfBoundsException("getCelement: Index value '" + index + "' not in range [0.." + (this._celementList.size() - 1) + "]");
        }
        return this._celementList.get(index);
    }

    public Celement[] getCelement() {
        Celement[] array = new Celement[]{};
        return this._celementList.toArray(array);
    }

    public List<Celement> getCelementCollection() {
        return this._celementList;
    }

    public int getCelementCount() {
        return this._celementList.size();
    }

    public Csubmap getCsubmap(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._csubmapList.size()) {
            throw new IndexOutOfBoundsException("getCsubmap: Index value '" + index + "' not in range [0.." + (this._csubmapList.size() - 1) + "]");
        }
        return this._csubmapList.get(index);
    }

    public Csubmap[] getCsubmap() {
        Csubmap[] array = new Csubmap[]{};
        return this._csubmapList.toArray(array);
    }

    public List<Csubmap> getCsubmapCollection() {
        return this._csubmapList;
    }

    public int getCsubmapCount() {
        return this._csubmapList.size();
    }

    public String getMapAccess() {
        return this._mapAccess;
    }

    public String getMapBG() {
        return this._mapBG;
    }

    public String getMapGroup() {
        return this._mapGroup;
    }

    public int getMapHeight() {
        return this._mapHeight;
    }

    public String getMapName() {
        return this._mapName;
    }

    public String getMapOwner() {
        return this._mapOwner;
    }

    public int getMapWidth() {
        return this._mapWidth;
    }

    public boolean hasMapHeight() {
        return this._has_mapHeight;
    }

    public boolean hasMapWidth() {
        return this._has_mapWidth;
    }

    public int hashCode() {
        int result = 17;
        if (this._mapName != null) {
            result = 37 * result + this._mapName.hashCode();
        }
        if (this._mapOwner != null) {
            result = 37 * result + this._mapOwner.hashCode();
        }
        if (this._mapGroup != null) {
            result = 37 * result + this._mapGroup.hashCode();
        }
        if (this._mapAccess != null) {
            result = 37 * result + this._mapAccess.hashCode();
        }
        if (this._mapBG != null) {
            result = 37 * result + this._mapBG.hashCode();
        }
        result = 37 * result + this._mapWidth;
        result = 37 * result + this._mapHeight;
        if (this._celementList != null) {
            result = 37 * result + ((Object)this._celementList).hashCode();
        }
        if (this._csubmapList != null) {
            result = 37 * result + ((Object)this._csubmapList).hashCode();
        }
        return result;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Celement> iterateCelement() {
        return this._celementList.iterator();
    }

    public Iterator<Csubmap> iterateCsubmap() {
        return this._csubmapList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllCelement() {
        this._celementList.clear();
    }

    public void removeAllCsubmap() {
        this._csubmapList.clear();
    }

    public boolean removeCelement(Celement vCelement) {
        boolean removed = this._celementList.remove(vCelement);
        return removed;
    }

    public Celement removeCelementAt(int index) {
        Celement obj = this._celementList.remove(index);
        return obj;
    }

    public boolean removeCsubmap(Csubmap vCsubmap) {
        boolean removed = this._csubmapList.remove(vCsubmap);
        return removed;
    }

    public Csubmap removeCsubmapAt(int index) {
        Csubmap obj = this._csubmapList.remove(index);
        return obj;
    }

    public void setCelement(int index, Celement vCelement) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._celementList.size()) {
            throw new IndexOutOfBoundsException("setCelement: Index value '" + index + "' not in range [0.." + (this._celementList.size() - 1) + "]");
        }
        this._celementList.set(index, vCelement);
    }

    public void setCelement(Celement[] vCelementArray) {
        this._celementList.clear();
        for (int i = 0; i < vCelementArray.length; ++i) {
            this._celementList.add(vCelementArray[i]);
        }
    }

    public void setCelement(List<Celement> vCelementList) {
        this._celementList.clear();
        this._celementList.addAll(vCelementList);
    }

    public void setCelementCollection(List<Celement> celementList) {
        this._celementList = celementList;
    }

    public void setCsubmap(int index, Csubmap vCsubmap) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._csubmapList.size()) {
            throw new IndexOutOfBoundsException("setCsubmap: Index value '" + index + "' not in range [0.." + (this._csubmapList.size() - 1) + "]");
        }
        this._csubmapList.set(index, vCsubmap);
    }

    public void setCsubmap(Csubmap[] vCsubmapArray) {
        this._csubmapList.clear();
        for (int i = 0; i < vCsubmapArray.length; ++i) {
            this._csubmapList.add(vCsubmapArray[i]);
        }
    }

    public void setCsubmap(List<Csubmap> vCsubmapList) {
        this._csubmapList.clear();
        this._csubmapList.addAll(vCsubmapList);
    }

    public void setCsubmapCollection(List<Csubmap> csubmapList) {
        this._csubmapList = csubmapList;
    }

    public void setMapAccess(String mapAccess) {
        this._mapAccess = mapAccess;
    }

    public void setMapBG(String mapBG) {
        this._mapBG = mapBG;
    }

    public void setMapGroup(String mapGroup) {
        this._mapGroup = mapGroup;
    }

    public void setMapHeight(int mapHeight) {
        this._mapHeight = mapHeight;
        this._has_mapHeight = true;
    }

    public void setMapName(String mapName) {
        this._mapName = mapName;
    }

    public void setMapOwner(String mapOwner) {
        this._mapOwner = mapOwner;
    }

    public void setMapWidth(int mapWidth) {
        this._mapWidth = mapWidth;
        this._has_mapWidth = true;
    }

    public static Cmap unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Cmap)Unmarshaller.unmarshal(Cmap.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

