/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.datacollection;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.core.xml.ValidateUsing;
import org.xml.sax.ContentHandler;

@XmlRootElement(name="rrd", namespace="http://xmlns.opennms.org/xsd/config/datacollection")
@XmlAccessorType(value=XmlAccessType.NONE)
@ValidateUsing(value="datacollection-config.xsd")
public class Rrd
implements Serializable {
    private static final long serialVersionUID = 8501536919916316365L;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private Integer m_step;
    private List<String> m_rras = new ArrayList<String>();

    public void addRra(String rra) throws IndexOutOfBoundsException {
        this.m_rras.add(rra.intern());
    }

    public void addRra(int index, String rra) throws IndexOutOfBoundsException {
        this.m_rras.add(index, rra.intern());
    }

    public void deleteStep() {
        this.m_step = null;
    }

    public Enumeration<String> enumerateRra() {
        return Collections.enumeration(this.m_rras);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Rrd) {
            Rrd temp = (Rrd)obj;
            return new EqualsBuilder().append(this.m_rras, temp.m_rras).append((Object)this.m_step, (Object)temp.m_step).isEquals();
        }
        return false;
    }

    public String getRra(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_rras.size()) {
            throw new IndexOutOfBoundsException("getRra: Index value '" + index + "' not in range [0.." + (this.m_rras.size() - 1) + "]");
        }
        return this.m_rras.get(index);
    }

    @XmlElement(name="rra", required=true)
    public String[] getRra() {
        return this.m_rras.toArray(EMPTY_STRING_ARRAY);
    }

    public List<String> getRraCollection() {
        return this.m_rras;
    }

    public int getRraCount() {
        return this.m_rras.size();
    }

    @XmlAttribute(name="step", required=true)
    public Integer getStep() {
        return this.m_step == null ? 0 : this.m_step;
    }

    public boolean hasStep() {
        return this.m_step != null;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.m_step;
        if (this.m_rras != null) {
            result = 37 * result + ((Object)this.m_rras).hashCode();
        }
        return result;
    }

    @Deprecated
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<String> iterateRra() {
        return this.m_rras.iterator();
    }

    @Deprecated
    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    @Deprecated
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllRra() {
        this.m_rras.clear();
    }

    public boolean removeRra(String rra) {
        return this.m_rras.remove(rra);
    }

    public String removeRraAt(int index) {
        return this.m_rras.remove(index);
    }

    public void setRra(int index, String rra) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_rras.size()) {
            throw new IndexOutOfBoundsException("setRra: Index value '" + index + "' not in range [0.." + (this.m_rras.size() - 1) + "]");
        }
        this.m_rras.set(index, rra.intern());
    }

    public void setRra(String[] rras) {
        this.m_rras.clear();
        for (int i = 0; i < rras.length; ++i) {
            this.m_rras.add(rras[i].intern());
        }
    }

    public void setRra(List<String> rras) {
        this.m_rras.clear();
        for (String rra : rras) {
            this.m_rras.add(rra.intern());
        }
    }

    public void setRraCollection(List<String> rras) {
        this.m_rras = new ArrayList<String>();
        for (String rra : rras) {
            this.m_rras.add(rra.intern());
        }
    }

    public void setStep(Integer step) {
        this.m_step = step;
    }

    @Deprecated
    public static Rrd unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Rrd)Unmarshaller.unmarshal(Rrd.class, (Reader)reader);
    }

    @Deprecated
    public void validate() throws ValidationException {
        new Validator().validate((Object)this);
    }
}

