/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.collectd.jmx;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.collectd.jmx.CompMember;
import org.xml.sax.ContentHandler;

@XmlRootElement(name="comp-attrib")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CompAttrib
implements Serializable {
    @XmlAttribute(name="name", required=true)
    private String _name;
    @XmlAttribute(name="alias")
    private String _alias;
    @XmlAttribute(name="type", required=true)
    private String _type;
    @XmlElement(name="comp-member")
    private List<CompMember> _compMemberList = new ArrayList<CompMember>();

    public void addCompMember(CompMember vCompMember) throws IndexOutOfBoundsException {
        this._compMemberList.add(vCompMember);
    }

    public void addCompMember(int index, CompMember vCompMember) throws IndexOutOfBoundsException {
        this._compMemberList.add(index, vCompMember);
    }

    public Enumeration<CompMember> enumerateCompMember() {
        return Collections.enumeration(this._compMemberList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CompAttrib) {
            CompAttrib temp = (CompAttrib)obj;
            if (this._name != null) {
                if (temp._name == null) {
                    return false;
                }
                if (!this._name.equals(temp._name)) {
                    return false;
                }
            } else if (temp._name != null) {
                return false;
            }
            if (this._alias != null) {
                if (temp._alias == null) {
                    return false;
                }
                if (!this._alias.equals(temp._alias)) {
                    return false;
                }
            } else if (temp._alias != null) {
                return false;
            }
            if (this._type != null) {
                if (temp._type == null) {
                    return false;
                }
                if (!this._type.equals(temp._type)) {
                    return false;
                }
            } else if (temp._type != null) {
                return false;
            }
            if (this._compMemberList != null) {
                if (temp._compMemberList == null) {
                    return false;
                }
                if (!((Object)this._compMemberList).equals(temp._compMemberList)) {
                    return false;
                }
            } else if (temp._compMemberList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public String getAlias() {
        return this._alias;
    }

    public CompMember getCompMember(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._compMemberList.size()) {
            throw new IndexOutOfBoundsException("getCompMember: Index value '" + index + "' not in range [0.." + (this._compMemberList.size() - 1) + "]");
        }
        return this._compMemberList.get(index);
    }

    public CompMember[] getCompMember() {
        CompMember[] array = new CompMember[]{};
        return this._compMemberList.toArray(array);
    }

    public List<CompMember> getCompMemberCollection() {
        return this._compMemberList;
    }

    public int getCompMemberCount() {
        return this._compMemberList.size();
    }

    public String getName() {
        return this._name;
    }

    public String getType() {
        return this._type;
    }

    public int hashCode() {
        int result = 17;
        if (this._name != null) {
            result = 37 * result + this._name.hashCode();
        }
        if (this._alias != null) {
            result = 37 * result + this._alias.hashCode();
        }
        if (this._type != null) {
            result = 37 * result + this._type.hashCode();
        }
        if (this._compMemberList != null) {
            result = 37 * result + ((Object)this._compMemberList).hashCode();
        }
        return result;
    }

    @Deprecated
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<CompMember> iterateCompMember() {
        return this._compMemberList.iterator();
    }

    @Deprecated
    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    @Deprecated
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllCompMember() {
        this._compMemberList.clear();
    }

    public boolean removeCompMember(CompMember vCompMember) {
        boolean removed = this._compMemberList.remove(vCompMember);
        return removed;
    }

    public CompMember removeCompMemberAt(int index) {
        CompMember obj = this._compMemberList.remove(index);
        return obj;
    }

    public void setAlias(String alias) {
        this._alias = alias;
    }

    public void setCompMember(int index, CompMember vCompMember) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._compMemberList.size()) {
            throw new IndexOutOfBoundsException("setCompMember: Index value '" + index + "' not in range [0.." + (this._compMemberList.size() - 1) + "]");
        }
        this._compMemberList.set(index, vCompMember);
    }

    public void setCompMember(CompMember[] vCompMemberArray) {
        this._compMemberList.clear();
        for (int i = 0; i < vCompMemberArray.length; ++i) {
            this._compMemberList.add(vCompMemberArray[i]);
        }
    }

    public void setCompMember(List<CompMember> vCompMemberList) {
        this._compMemberList.clear();
        this._compMemberList.addAll(vCompMemberList);
    }

    public void setCompMemberCollection(List<CompMember> compMemberList) {
        this._compMemberList = compMemberList;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setType(String type) {
        this._type = type;
    }

    @Deprecated
    public static CompAttrib unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (CompAttrib)Unmarshaller.unmarshal(CompAttrib.class, (Reader)reader);
    }

    @Deprecated
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

