/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.charts;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.charts.BarChart;
import org.xml.sax.ContentHandler;

public class ChartConfiguration
implements Serializable {
    private List<BarChart> _barChartList = new ArrayList<BarChart>();

    public void addBarChart(BarChart vBarChart) throws IndexOutOfBoundsException {
        this._barChartList.add(vBarChart);
    }

    public void addBarChart(int index, BarChart vBarChart) throws IndexOutOfBoundsException {
        this._barChartList.add(index, vBarChart);
    }

    public Enumeration<BarChart> enumerateBarChart() {
        return Collections.enumeration(this._barChartList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ChartConfiguration) {
            ChartConfiguration temp = (ChartConfiguration)obj;
            if (this._barChartList != null) {
                if (temp._barChartList == null) {
                    return false;
                }
                if (!((Object)this._barChartList).equals(temp._barChartList)) {
                    return false;
                }
            } else if (temp._barChartList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public BarChart getBarChart(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._barChartList.size()) {
            throw new IndexOutOfBoundsException("getBarChart: Index value '" + index + "' not in range [0.." + (this._barChartList.size() - 1) + "]");
        }
        return this._barChartList.get(index);
    }

    public BarChart[] getBarChart() {
        BarChart[] array = new BarChart[]{};
        return this._barChartList.toArray(array);
    }

    public List<BarChart> getBarChartCollection() {
        return this._barChartList;
    }

    public int getBarChartCount() {
        return this._barChartList.size();
    }

    public int hashCode() {
        int result = 17;
        if (this._barChartList != null) {
            result = 37 * result + ((Object)this._barChartList).hashCode();
        }
        return result;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<BarChart> iterateBarChart() {
        return this._barChartList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllBarChart() {
        this._barChartList.clear();
    }

    public boolean removeBarChart(BarChart vBarChart) {
        boolean removed = this._barChartList.remove(vBarChart);
        return removed;
    }

    public BarChart removeBarChartAt(int index) {
        BarChart obj = this._barChartList.remove(index);
        return obj;
    }

    public void setBarChart(int index, BarChart vBarChart) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._barChartList.size()) {
            throw new IndexOutOfBoundsException("setBarChart: Index value '" + index + "' not in range [0.." + (this._barChartList.size() - 1) + "]");
        }
        this._barChartList.set(index, vBarChart);
    }

    public void setBarChart(BarChart[] vBarChartArray) {
        this._barChartList.clear();
        for (int i = 0; i < vBarChartArray.length; ++i) {
            this._barChartList.add(vBarChartArray[i]);
        }
    }

    public void setBarChart(List<BarChart> vBarChartList) {
        this._barChartList.clear();
        this._barChartList.addAll(vBarChartList);
    }

    public void setBarChartCollection(List<BarChart> barChartList) {
        this._barChartList = barChartList;
    }

    public static ChartConfiguration unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (ChartConfiguration)Unmarshaller.unmarshal(ChartConfiguration.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

