/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.filter;

import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="join")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="database-schema.xsd")
public class Join
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final String DEFAULT_TYPE = "inner";
    @XmlAttribute(name="type")
    private String m_type;
    @XmlAttribute(name="column", required=true)
    private String m_column;
    @XmlAttribute(name="table", required=true)
    private String m_table;
    @XmlAttribute(name="table-column", required=true)
    private String m_tableColumn;

    public String getType() {
        return this.m_type != null ? this.m_type : DEFAULT_TYPE;
    }

    public void setType(String type) {
        this.m_type = ConfigUtils.normalizeString(type);
    }

    public String getColumn() {
        return this.m_column;
    }

    public void setColumn(String column) {
        this.m_column = ConfigUtils.assertNotEmpty(column, "column");
    }

    public String getTable() {
        return this.m_table;
    }

    public void setTable(String table) {
        this.m_table = ConfigUtils.assertNotEmpty(table, "table");
    }

    public String getTableColumn() {
        return this.m_tableColumn;
    }

    public void setTableColumn(String tableColumn) {
        this.m_tableColumn = ConfigUtils.assertNotEmpty(tableColumn, "table-column");
    }

    public int hashCode() {
        return Objects.hash(this.m_type, this.m_column, this.m_table, this.m_tableColumn);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Join) {
            Join that = (Join)obj;
            return Objects.equals(this.m_type, that.m_type) && Objects.equals(this.m_column, that.m_column) && Objects.equals(this.m_table, that.m_table) && Objects.equals(this.m_tableColumn, that.m_tableColumn);
        }
        return false;
    }
}

