/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.viewsdisplay;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="section")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="viewsdisplay.xsd")
public class Section
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlElement(name="section-name", required=true)
    private String m_sectionName;
    @XmlElement(name="category", required=true)
    private List<String> m_categories = new ArrayList<String>();

    public String getSectionName() {
        return this.m_sectionName;
    }

    public void setSectionName(String sectionName) {
        this.m_sectionName = ConfigUtils.assertNotEmpty(sectionName, "section-name");
    }

    public List<String> getCategories() {
        return this.m_categories;
    }

    public void setCategories(List<String> categories) {
        if (categories == this.m_categories) {
            return;
        }
        this.m_categories.clear();
        if (categories != null) {
            this.m_categories.addAll(categories);
        }
    }

    public void addCategory(String category) {
        this.m_categories.add(category);
    }

    public boolean removeCategory(String category) {
        return this.m_categories.remove(category);
    }

    public int hashCode() {
        return Objects.hash(this.m_sectionName, this.m_categories);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Section) {
            Section that = (Section)obj;
            return Objects.equals(this.m_sectionName, that.m_sectionName) && Objects.equals(this.m_categories, that.m_categories);
        }
        return false;
    }
}

