/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.hardware;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.hardware.MibObj;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="hw-extension")
@XmlAccessorType(value=XmlAccessType.NONE)
@ValidateUsing(value="snmp-hardware-inventory-adapter-configuration.xsd")
public class HwExtension
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String m_name;
    private String m_sysOidMask;
    private List<MibObj> m_mibObjects = new ArrayList<MibObj>();

    public HwExtension() {
    }

    public HwExtension(String name, String sysOidMask) {
        this.setName(name);
        this.setSysOidMask(sysOidMask);
    }

    @XmlAttribute(name="name", required=true)
    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    @XmlAttribute(name="sysOidMask", required=true)
    public String getSysOidMask() {
        return this.m_sysOidMask;
    }

    public void setSysOidMask(String sysOidMask) {
        this.m_sysOidMask = ConfigUtils.assertNotEmpty(sysOidMask, "sysOidMask");
    }

    @XmlElement(name="mibObj", required=true)
    public List<MibObj> getMibObjects() {
        return this.m_mibObjects;
    }

    public MibObj getMibObjectByAlias(String name) {
        return this.m_mibObjects.stream().filter(obj -> name.equals(obj.getAlias())).findFirst().orElse(null);
    }

    public MibObj getMibObjectByOid(String oid) {
        return this.m_mibObjects.stream().filter(obj -> oid.equals(obj.getOid().toString())).findFirst().orElse(null);
    }

    public void setMibObjects(List<MibObj> mibObjects) {
        if (mibObjects == this.m_mibObjects) {
            return;
        }
        this.m_mibObjects.clear();
        if (mibObjects != null) {
            this.m_mibObjects.addAll(mibObjects);
        }
    }

    public void addMibObject(MibObj mibObj) {
        this.m_mibObjects.add(mibObj);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HwExtension) {
            HwExtension that = (HwExtension)obj;
            return Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_sysOidMask, that.m_sysOidMask) && Objects.equals(this.m_mibObjects, that.m_mibObjects);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_sysOidMask, this.m_mibObjects);
    }

    public String toString() {
        return "HwExtension [m_name=" + this.m_name + ", m_sysOidMask=" + this.m_sysOidMask + ", m_mibObjects=" + this.m_mibObjects + "]";
    }
}

