/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.wsmanAsset.adapter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;
import org.opennms.netmgt.config.wsmanAsset.adapter.AssetField;

@XmlRootElement(name="package")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="snmp-asset-adapter-configuration.xsd")
public class Package
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlElement(name="vendor", required=true)
    private String m_vendor;
    @XmlElement(name="assetField", required=true)
    private List<AssetField> m_assetFields = new ArrayList<AssetField>();

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public String getVendor() {
        return this.m_vendor;
    }

    public void setVendor(String vendor) {
        this.m_vendor = ConfigUtils.assertNotEmpty(vendor, "vendor");
    }

    public List<AssetField> getAssetFields() {
        return this.m_assetFields;
    }

    public void setAssetFields(List<AssetField> assetFields) {
        ConfigUtils.assertMinimumSize(assetFields, 1L, "assetField");
        if (assetFields == this.m_assetFields) {
            return;
        }
        this.m_assetFields.clear();
        if (assetFields != null) {
            this.m_assetFields.addAll(assetFields);
        }
    }

    public void addAssetField(AssetField assetField) {
        this.m_assetFields.add(assetField);
    }

    public boolean removeAssetField(AssetField assetField) {
        return this.m_assetFields.remove(assetField);
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_vendor, this.m_assetFields);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Package) {
            Package that = (Package)obj;
            return Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_vendor, that.m_vendor) && Objects.equals(this.m_assetFields, that.m_assetFields);
        }
        return false;
    }
}

