/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xml.eventconf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;
import org.opennms.netmgt.xml.eventconf.ManagedObject;
import org.opennms.netmgt.xml.eventconf.UpdateField;

@XmlRootElement(name="alarm-data")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="eventconf.xsd")
public class AlarmData
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="reduction-key", required=true)
    private String m_reductionKey;
    @XmlAttribute(name="alarm-type")
    private Integer m_alarmType;
    @XmlAttribute(name="clear-key")
    private String m_clearKey;
    @XmlAttribute(name="auto-clean")
    private Boolean m_autoClean;
    @XmlAttribute(name="x733-alarm-type")
    private String m_x733AlarmType;
    @XmlAttribute(name="x733-probable-cause")
    private Integer m_x733ProbableCause;
    @XmlElement(name="update-field", required=false)
    private List<UpdateField> m_updateFields = new ArrayList<UpdateField>();
    @XmlElement(name="managed-object", required=false)
    private ManagedObject m_managedObject;

    public String getReductionKey() {
        return this.m_reductionKey;
    }

    public void setReductionKey(String reductionKey) {
        this.m_reductionKey = ConfigUtils.normalizeAndInternString(reductionKey);
    }

    public Integer getAlarmType() {
        return this.m_alarmType;
    }

    public void setAlarmType(Integer alarmType) {
        this.m_alarmType = (Integer)ConfigUtils.assertMinimumInclusive((Number)ConfigUtils.assertNotNull(alarmType, "alarm-type"), 1L, "alarm-type");
    }

    public String getClearKey() {
        return this.m_clearKey;
    }

    public void setClearKey(String clearKey) {
        this.m_clearKey = ConfigUtils.normalizeAndInternString(clearKey);
    }

    public Boolean getAutoClean() {
        return this.m_autoClean == null ? Boolean.FALSE : this.m_autoClean;
    }

    public void setAutoClean(Boolean autoClean) {
        this.m_autoClean = autoClean;
    }

    public String getX733AlarmType() {
        return this.m_x733AlarmType;
    }

    public void setX733AlarmType(String x733AlarmType) {
        this.m_x733AlarmType = ConfigUtils.normalizeAndInternString(x733AlarmType);
    }

    public Integer getX733ProbableCause() {
        return this.m_x733ProbableCause;
    }

    public void setX733ProbableCause(Integer x733ProbableCause) {
        this.m_x733ProbableCause = x733ProbableCause;
    }

    public List<UpdateField> getUpdateFields() {
        return Collections.unmodifiableList(this.m_updateFields);
    }

    public void setUpdateFields(List<UpdateField> updateFields) {
        if (this.m_updateFields == updateFields) {
            return;
        }
        this.m_updateFields.clear();
        if (updateFields != null) {
            this.m_updateFields.addAll(updateFields);
        }
    }

    public ManagedObject getManagedObject() {
        return this.m_managedObject;
    }

    public void setManagedObject(ManagedObject managedObject) {
        this.m_managedObject = managedObject;
    }

    public int hashCode() {
        return Objects.hash(this.m_reductionKey, this.m_alarmType, this.m_clearKey, this.m_autoClean, this.m_x733AlarmType, this.m_x733ProbableCause, this.m_updateFields, this.m_managedObject);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AlarmData) {
            AlarmData that = (AlarmData)obj;
            return Objects.equals(this.m_reductionKey, that.m_reductionKey) && Objects.equals(this.m_alarmType, that.m_alarmType) && Objects.equals(this.m_clearKey, that.m_clearKey) && Objects.equals(this.m_autoClean, that.m_autoClean) && Objects.equals(this.m_x733AlarmType, that.m_x733AlarmType) && Objects.equals(this.m_x733ProbableCause, that.m_x733ProbableCause) && Objects.equals(this.m_updateFields, that.m_updateFields) && Objects.equals(this.m_managedObject, that.m_managedObject);
        }
        return false;
    }
}

