/*******************************************************************************
 * This file is part of OpenNMS(R).
 * 
 * Copyright (C) 2017 The OpenNMS Group, Inc.
 * OpenNMS(R) is Copyright (C) 1999-2017 The OpenNMS Group, Inc.
 * 
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 * 
 * OpenNMS(R) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 * 
 * OpenNMS(R) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with OpenNMS(R).  If not, see:
 *     http://www.gnu.org/licenses/
 * 
 * For more information contact:
 *     OpenNMS(R) Licensing <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 *******************************************************************************/

package org.opennms.netmgt.config.rancid.adapter;


import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.opennms.core.xml.ValidateUsing;

/**
 * Configuration of Policy functionality
 */
@XmlRootElement(name = "policies")
@XmlAccessorType(XmlAccessType.FIELD)
@ValidateUsing("rancid-adapter-configuration.xsd")
public class Policies implements Serializable {
    private static final long serialVersionUID = 2L;

    /**
     * This represents a policy to manage a provisioned node
     *  if matched a node will be added updated or deleted using
     *  the element attribute definitions .
     */
    @XmlElement(name = "policy-manage", required = true)
    private List<PolicyManage> m_policyManages = new ArrayList<>();

    public Policies() {
    }

    public List<PolicyManage> getPolicyManages() {
        return m_policyManages;
    }

    public void setPolicyManages(final List<PolicyManage> policyManages) {
        if (policyManages == m_policyManages) return;
        m_policyManages.clear();
        if (policyManages != null) m_policyManages.addAll(policyManages);
    }

    public void addPolicyManage(final PolicyManage policyManage) {
        m_policyManages.add(policyManage);
    }

    public boolean removePolicyManage(final PolicyManage policyManage) {
        return m_policyManages.remove(policyManage);
    }

    @Override
    public int hashCode() {
        return Objects.hash(m_policyManages);
    }

    @Override
    public boolean equals(final Object obj) {
        if ( this == obj ) {
            return true;
        }

        if (obj instanceof Policies) {
            final Policies that = (Policies)obj;
            return Objects.equals(this.m_policyManages, that.m_policyManages);
        }
        return false;
    }

}
