/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.discovery;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="exclude-range")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="discovery-configuration.xsd")
public class ExcludeRange
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="begin", required=true)
    private String m_begin;
    @XmlElement(name="end", required=true)
    private String m_end;
    @XmlAttribute(name="location")
    private String m_location;

    public ExcludeRange() {
    }

    public ExcludeRange(String begin, String end) {
        this.setBegin(begin);
        this.setEnd(end);
    }

    public String getBegin() {
        return this.m_begin;
    }

    public void setBegin(String begin) {
        this.m_begin = ConfigUtils.assertNotEmpty(begin, "begin");
    }

    public String getEnd() {
        return this.m_end;
    }

    public void setEnd(String end) {
        this.m_end = ConfigUtils.assertNotEmpty(end, "end");
    }

    public Optional<String> getLocation() {
        return Optional.ofNullable(this.m_location);
    }

    public void setLocation(String location) {
        this.m_location = location;
    }

    public int hashCode() {
        return Objects.hash(this.m_begin, this.m_end, this.m_location);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ExcludeRange) {
            ExcludeRange temp = (ExcludeRange)obj;
            return Objects.equals(temp.m_begin, this.m_begin) && Objects.equals(temp.m_end, this.m_end) && Objects.equals(temp.m_location, this.m_location);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("begin", (Object)this.m_begin).add("end", (Object)this.m_end).add("location", (Object)this.m_location).toString();
    }
}

