/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.discovery;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.discovery.Detector;
import org.opennms.netmgt.config.discovery.ExcludeRange;
import org.opennms.netmgt.config.discovery.IncludeRange;
import org.opennms.netmgt.config.discovery.IncludeUrl;
import org.opennms.netmgt.config.discovery.Specific;

@XmlRootElement(name="definition")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="discovery-configuration.xsd")
public class Definition
implements Serializable {
    private static final long serialVersionUID = 5369200192316960658L;
    @XmlAttribute(name="location")
    private String location;
    @XmlAttribute(name="retries")
    private Integer retries;
    @XmlAttribute(name="timeout")
    private Long timeout;
    @XmlAttribute(name="foreign-source")
    private String foreignSource;
    @XmlElementWrapper(name="detectors")
    @XmlElement(name="detector")
    private List<Detector> detectors = new ArrayList<Detector>();
    @XmlElement(name="specific")
    private List<Specific> specifics = new ArrayList<Specific>();
    @XmlElement(name="include-range")
    private List<IncludeRange> includeRanges = new ArrayList<IncludeRange>();
    @XmlElement(name="exclude-range")
    private List<ExcludeRange> excludeRanges = new ArrayList<ExcludeRange>();
    @XmlElement(name="include-url")
    private List<IncludeUrl> includeUrls = new ArrayList<IncludeUrl>();

    public Optional<String> getLocation() {
        return Optional.ofNullable(this.location);
    }

    public String getLocationName() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Optional<Integer> getRetries() {
        return Optional.ofNullable(this.retries);
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public Optional<Long> getTimeout() {
        return Optional.ofNullable(this.timeout);
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public String getForeignSource() {
        return this.foreignSource;
    }

    public void setForeignSource(String foreignSource) {
        this.foreignSource = foreignSource;
    }

    public List<Specific> getSpecifics() {
        return this.specifics;
    }

    public void setSpecifics(List<Specific> specifics) {
        this.specifics = specifics;
    }

    public void addSpecific(Specific specific) {
        this.specifics.add(specific);
    }

    public List<IncludeRange> getIncludeRanges() {
        return this.includeRanges;
    }

    public void setIncludeRanges(List<IncludeRange> includeRanges) {
        this.includeRanges = includeRanges;
    }

    public void addIncludeRange(IncludeRange includeRange) {
        this.includeRanges.add(includeRange);
    }

    public List<ExcludeRange> getExcludeRanges() {
        return this.excludeRanges;
    }

    public void setExcludeRanges(List<ExcludeRange> excludeRanges) {
        this.excludeRanges = excludeRanges;
    }

    public void addExcludeRange(ExcludeRange excludeRange) {
        this.excludeRanges.add(excludeRange);
    }

    public List<Detector> getDetectors() {
        return this.detectors;
    }

    public void setDetectors(List<Detector> detectors) {
        this.detectors = detectors;
    }

    public void addDetector(Detector detector) {
        this.detectors.add(detector);
    }

    public List<IncludeUrl> getIncludeUrls() {
        return this.includeUrls;
    }

    public void setIncludeUrls(List<IncludeUrl> includeUrls) {
        if (includeUrls == this.includeUrls) {
            return;
        }
        this.includeUrls.clear();
        if (includeUrls != null) {
            this.includeUrls.addAll(includeUrls);
        }
    }

    public void addIncludeUrl(IncludeUrl includeUrl) {
        this.includeUrls.add(includeUrl);
    }

    public boolean removeIncludeUrl(IncludeUrl includeUrl) {
        return this.includeUrls.remove(includeUrl);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Definition that = (Definition)o;
        return Objects.equals(this.location, that.location) && Objects.equals(this.specifics, that.specifics) && Objects.equals(this.includeRanges, that.includeRanges) && Objects.equals(this.excludeRanges, that.excludeRanges) && Objects.equals(this.detectors, that.detectors);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.specifics, this.includeRanges, this.excludeRanges, this.detectors);
    }
}

