/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.snmpAsset.adapter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.snmpAsset.adapter.AssetField;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="package")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="snmp-asset-adapter-configuration.xsd")
public class Package
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlElement(name="sysoid", required=true)
    private String m_sysoid;
    @XmlElement(name="sysoidMask", required=true)
    private String m_sysoidMask;
    @XmlElement(name="assetField", required=true)
    private List<AssetField> m_assetFields = new ArrayList<AssetField>();

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public String getSysoid() {
        return this.m_sysoid;
    }

    public void setSysoid(String sysoid) {
        this.m_sysoid = ConfigUtils.assertNotEmpty(sysoid, "sysoid");
    }

    public String getSysoidMask() {
        return this.m_sysoidMask;
    }

    public void setSysoidMask(String sysoidMask) {
        this.m_sysoidMask = ConfigUtils.assertNotEmpty(sysoidMask, "sysoidMask");
    }

    public List<AssetField> getAssetFields() {
        return this.m_assetFields;
    }

    public void setAssetFields(List<AssetField> assetFields) {
        ConfigUtils.assertMinimumSize(assetFields, 1L, "assetField");
        if (assetFields == this.m_assetFields) {
            return;
        }
        this.m_assetFields.clear();
        if (assetFields != null) {
            this.m_assetFields.addAll(assetFields);
        }
    }

    public void addAssetField(AssetField assetField) {
        this.m_assetFields.add(assetField);
    }

    public boolean removeAssetField(AssetField assetField) {
        return this.m_assetFields.remove(assetField);
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_sysoid, this.m_sysoidMask, this.m_assetFields);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Package) {
            Package that = (Package)obj;
            return Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_sysoid, that.m_sysoid) && Objects.equals(this.m_sysoidMask, that.m_sysoidMask) && Objects.equals(this.m_assetFields, that.m_assetFields);
        }
        return false;
    }
}

