/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.snmpinterfacepoller;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="interface")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="snmp-interface-poller-configuration.xsd")
public class Interface
implements Serializable {
    private static final List<String> STATUS_CHOICES = Arrays.asList("on", "off");
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="criteria")
    private String m_criteria;
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlAttribute(name="interval", required=true)
    private Long m_interval;
    @XmlAttribute(name="user-defined")
    private Boolean m_userDefined = Boolean.FALSE;
    @XmlAttribute(name="status")
    private String m_status = "on";
    @XmlAttribute(name="port")
    private Integer m_port;
    @XmlAttribute(name="retry")
    private Integer m_retry;
    @XmlAttribute(name="timeout")
    private Integer m_timeout;
    @XmlAttribute(name="max-vars-per-pdu")
    private Integer m_maxVarsPerPdu;
    @XmlAttribute(name="max-interface-per-pdu")
    private Integer m_maxInterfacePerPdu;

    public Optional<String> getCriteria() {
        return Optional.ofNullable(this.m_criteria);
    }

    public void setCriteria(String criteria) {
        this.m_criteria = ConfigUtils.normalizeString(criteria);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public Long getInterval() {
        return this.m_interval;
    }

    public void setInterval(Long interval) {
        this.m_interval = ConfigUtils.assertNotNull(interval, "interval");
    }

    public Boolean getUserDefined() {
        return this.m_userDefined;
    }

    public void setUserDefined(Boolean userDefined) {
        this.m_userDefined = userDefined;
    }

    public String getStatus() {
        return this.m_status;
    }

    public void setStatus(String status) {
        this.m_status = ConfigUtils.assertOnlyContains(status, STATUS_CHOICES, "status");
    }

    public Optional<Integer> getPort() {
        return Optional.ofNullable(this.m_port);
    }

    public void setPort(Integer port) {
        this.m_port = ConfigUtils.assertMinimumInclusive(port, 1L, "port");
    }

    public Optional<Integer> getRetry() {
        return Optional.ofNullable(this.m_retry);
    }

    public void setRetry(Integer retry) {
        this.m_retry = retry;
    }

    public Optional<Integer> getTimeout() {
        return Optional.ofNullable(this.m_timeout);
    }

    public void setTimeout(Integer timeout) {
        this.m_timeout = timeout;
    }

    public Integer getMaxVarsPerPdu() {
        return this.m_maxVarsPerPdu != null ? this.m_maxVarsPerPdu : 10;
    }

    public void setMaxVarsPerPdu(Integer maxVarsPerPdu) {
        this.m_maxVarsPerPdu = maxVarsPerPdu;
    }

    public Integer getMaxInterfacePerPdu() {
        return this.m_maxInterfacePerPdu != null ? this.m_maxInterfacePerPdu : 0;
    }

    public void setMaxInterfacePerPdu(Integer maxInterfacePerPdu) {
        this.m_maxInterfacePerPdu = maxInterfacePerPdu;
    }

    public int hashCode() {
        return Objects.hash(this.m_criteria, this.m_name, this.m_interval, this.m_userDefined, this.m_status, this.m_port, this.m_retry, this.m_timeout, this.m_maxVarsPerPdu, this.m_maxInterfacePerPdu);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Interface) {
            Interface that = (Interface)obj;
            return Objects.equals(this.m_criteria, that.m_criteria) && Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_interval, that.m_interval) && Objects.equals(this.m_userDefined, that.m_userDefined) && Objects.equals(this.m_status, that.m_status) && Objects.equals(this.m_port, that.m_port) && Objects.equals(this.m_retry, that.m_retry) && Objects.equals(this.m_timeout, that.m_timeout) && Objects.equals(this.m_maxVarsPerPdu, this.m_maxVarsPerPdu) && Objects.equals(this.m_maxInterfacePerPdu, this.m_maxInterfacePerPdu);
        }
        return false;
    }
}

