/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.rws;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="standby-url")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="rws-configuration.xsd")
public class StandbyUrl
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final String DEFAULT_DIRECTORY = "/rws";
    @XmlAttribute(name="server_url", required=true)
    private String m_serverUrl;
    @XmlAttribute(name="timeout")
    private Integer m_timeout;
    @XmlAttribute(name="directory")
    private String m_directory;
    @XmlAttribute(name="username")
    private String m_username;
    @XmlAttribute(name="password")
    private String m_password;

    public String getServerUrl() {
        return this.m_serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.m_serverUrl = ConfigUtils.assertNotEmpty(serverUrl, "server_url");
    }

    public Integer getTimeout() {
        return this.m_timeout != null ? this.m_timeout : 3;
    }

    public void setTimeout(Integer timeout) {
        this.m_timeout = timeout;
    }

    public String getDirectory() {
        return this.m_directory != null ? this.m_directory : DEFAULT_DIRECTORY;
    }

    public void setDirectory(String directory) {
        this.m_directory = ConfigUtils.normalizeString(directory);
    }

    public Optional<String> getUsername() {
        return Optional.ofNullable(this.m_username);
    }

    public void setUsername(String username) {
        this.m_username = ConfigUtils.normalizeString(username);
    }

    public Optional<String> getPassword() {
        return Optional.ofNullable(this.m_password);
    }

    public void setPassword(String password) {
        this.m_password = ConfigUtils.normalizeString(password);
    }

    public int hashCode() {
        return Objects.hash(this.m_serverUrl, this.m_timeout, this.m_directory, this.m_username, this.m_password);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StandbyUrl) {
            StandbyUrl that = (StandbyUrl)obj;
            return Objects.equals(this.m_serverUrl, that.m_serverUrl) && Objects.equals(this.m_timeout, that.m_timeout) && Objects.equals(this.m_directory, that.m_directory) && Objects.equals(this.m_username, that.m_username) && Objects.equals(this.m_password, that.m_password);
        }
        return false;
    }
}

