/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.mailtransporttest;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.mailtransporttest.JavamailProperty;
import org.opennms.netmgt.config.mailtransporttest.SendmailHost;
import org.opennms.netmgt.config.mailtransporttest.SendmailMessage;
import org.opennms.netmgt.config.mailtransporttest.SendmailProtocol;
import org.opennms.netmgt.config.mailtransporttest.UserAuth;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="sendmail-test")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="mail-transport-test.xsd")
public class SendmailTest
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="debug")
    private Boolean m_debug;
    @XmlAttribute(name="use-authentication")
    private Boolean m_useAuthentication;
    @XmlAttribute(name="use-jmta")
    private Boolean m_useJmta;
    @XmlAttribute(name="attempt-interval")
    private Long m_attemptInterval;
    @XmlElement(name="javamail-property")
    private List<JavamailProperty> m_javamailProperties = new ArrayList<JavamailProperty>();
    @XmlElement(name="sendmail-host", required=true)
    private SendmailHost m_sendmailHost;
    @XmlElement(name="sendmail-protocol", required=true)
    private SendmailProtocol m_sendmailProtocol;
    @XmlElement(name="sendmail-message", required=true)
    private SendmailMessage m_sendmailMessage;
    @XmlElement(name="user-auth")
    private UserAuth m_userAuth;

    public SendmailTest() {
    }

    public SendmailTest(Long attemptInterval, Boolean debug, Boolean useAuthentication, Boolean useJmta) {
        this.setAttemptInterval(attemptInterval);
        this.setDebug(debug);
        this.setUseAuthentication(useAuthentication);
        this.setUseJmta(useJmta);
    }

    public Boolean getDebug() {
        return this.m_debug == null ? true : this.m_debug;
    }

    public void setDebug(Boolean debug) {
        this.m_debug = debug;
    }

    public Boolean getUseAuthentication() {
        return this.m_useAuthentication == null ? Boolean.FALSE : this.m_useAuthentication;
    }

    public void setUseAuthentication(Boolean useAuthentication) {
        this.m_useAuthentication = useAuthentication;
    }

    public Boolean getUseJmta() {
        return this.m_useJmta == null ? Boolean.TRUE : this.m_useJmta;
    }

    public void setUseJmta(Boolean useJmta) {
        this.m_useJmta = useJmta;
    }

    public Long getAttemptInterval() {
        return this.m_attemptInterval == null ? 3000L : this.m_attemptInterval;
    }

    public void setAttemptInterval(Long attemptInterval) {
        this.m_attemptInterval = attemptInterval;
    }

    public List<JavamailProperty> getJavamailProperties() {
        return this.m_javamailProperties;
    }

    public void setJavamailProperties(List<JavamailProperty> javamailProperties) {
        if (javamailProperties == this.m_javamailProperties) {
            return;
        }
        this.m_javamailProperties.clear();
        if (javamailProperties != null) {
            this.m_javamailProperties.addAll(javamailProperties);
        }
    }

    public void addJavamailProperty(JavamailProperty property) {
        this.m_javamailProperties.add(property);
    }

    public void addJavamailProperty(String name, String value) {
        this.m_javamailProperties.add(new JavamailProperty(name, value));
    }

    public boolean removeJavamailProperty(JavamailProperty javamailProperty) {
        return this.m_javamailProperties.remove(javamailProperty);
    }

    public SendmailHost getSendmailHost() {
        return this.m_sendmailHost;
    }

    public void setSendmailHost(SendmailHost sendmailHost) {
        this.m_sendmailHost = ConfigUtils.assertNotNull(sendmailHost, "sendmail-host");
    }

    public void setSendmailHost(String host, Long port) {
        this.m_sendmailHost = new SendmailHost(host, port);
    }

    public SendmailProtocol getSendmailProtocol() {
        return this.m_sendmailProtocol;
    }

    public void setSendmailProtocol(SendmailProtocol sendmailProtocol) {
        this.m_sendmailProtocol = ConfigUtils.assertNotNull(sendmailProtocol, "sendmail-protocol");
    }

    public SendmailMessage getSendmailMessage() {
        return this.m_sendmailMessage;
    }

    public void setSendmailMessage(SendmailMessage sendmailMessage) {
        this.m_sendmailMessage = ConfigUtils.assertNotNull(sendmailMessage, "sendmail-message");
    }

    public Optional<UserAuth> getUserAuth() {
        return Optional.ofNullable(this.m_userAuth);
    }

    public void setUserAuth(UserAuth userAuth) {
        this.m_userAuth = userAuth;
    }

    public void setUserAuth(String username, String password) {
        this.m_userAuth = new UserAuth(username, password);
    }

    public int hashCode() {
        return Objects.hash(this.m_debug, this.m_useAuthentication, this.m_useJmta, this.m_attemptInterval, this.m_javamailProperties, this.m_sendmailHost, this.m_sendmailProtocol, this.m_sendmailMessage, this.m_userAuth);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SendmailTest) {
            SendmailTest that = (SendmailTest)obj;
            return Objects.equals(this.m_debug, that.m_debug) && Objects.equals(this.m_useAuthentication, that.m_useAuthentication) && Objects.equals(this.m_useJmta, that.m_useJmta) && Objects.equals(this.m_attemptInterval, that.m_attemptInterval) && Objects.equals(this.m_javamailProperties, that.m_javamailProperties) && Objects.equals(this.m_sendmailHost, that.m_sendmailHost) && Objects.equals(this.m_sendmailProtocol, that.m_sendmailProtocol) && Objects.equals(this.m_sendmailMessage, that.m_sendmailMessage) && Objects.equals(this.m_userAuth, that.m_userAuth);
        }
        return false;
    }
}

