/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.threshd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.threshd.Parameter;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="thresholder")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="thresholding.xsd")
public class Thresholder
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="service", required=true)
    private String m_service;
    @XmlAttribute(name="class-name", required=true)
    private String m_className;
    @XmlElement(name="parameter")
    private List<Parameter> m_parameters = new ArrayList<Parameter>();

    public String getService() {
        return this.m_service;
    }

    public void setService(String service) {
        this.m_service = ConfigUtils.assertNotEmpty(service, "service");
    }

    public String getClassName() {
        return this.m_className;
    }

    public void setClassName(String className) {
        this.m_className = ConfigUtils.assertNotEmpty(className, "class-name");
    }

    public List<Parameter> getParameters() {
        return this.m_parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        if (parameters == this.m_parameters) {
            return;
        }
        this.m_parameters.clear();
        if (parameters != null) {
            this.m_parameters.addAll(parameters);
        }
    }

    public void addParameter(Parameter parameter) {
        this.m_parameters.add(parameter);
    }

    public boolean removeParameter(Parameter parameter) {
        return this.m_parameters.remove(parameter);
    }

    public int hashCode() {
        return Objects.hash(this.m_service, this.m_className, this.m_parameters);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Thresholder) {
            Thresholder that = (Thresholder)obj;
            return Objects.equals(this.m_service, that.m_service) && Objects.equals(this.m_className, that.m_className) && Objects.equals(this.m_parameters, that.m_parameters);
        }
        return false;
    }
}

