/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.wmi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;
import org.opennms.netmgt.config.wmi.Attrib;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="", propOrder={"m_attribs"})
@XmlRootElement(name="wpm")
@ValidateUsing(value="wmi-datacollection.xsd")
public class Wpm
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlElement(name="attrib")
    protected List<Attrib> m_attribs = new ArrayList<Attrib>();
    @XmlAttribute(name="name", required=true)
    protected String m_name;
    @XmlAttribute(name="wmiClass", required=true)
    protected String m_wmiClass;
    @XmlAttribute(name="keyvalue", required=true)
    protected String m_keyvalue;
    @XmlAttribute(name="recheckInterval", required=true)
    protected Integer m_recheckInterval;
    @XmlAttribute(name="ifType", required=true)
    protected String m_ifType;
    @XmlAttribute(name="resourceType", required=true)
    protected String m_resourceType;
    @XmlAttribute(name="wmiNamespace")
    protected String m_wmiNamespace;

    public List<Attrib> getAttribs() {
        return this.m_attribs;
    }

    public void setAttribs(List<Attrib> attribs) {
        if (attribs == this.m_attribs) {
            return;
        }
        this.m_attribs.clear();
        if (attribs != null) {
            this.m_attribs.addAll(attribs);
        }
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public String getWmiClass() {
        return this.m_wmiClass;
    }

    public void setWmiClass(String wmiClass) {
        this.m_wmiClass = ConfigUtils.assertNotEmpty(wmiClass, "wmiClass");
    }

    public String getKeyvalue() {
        return this.m_keyvalue;
    }

    public void setKeyvalue(String keyvalue) {
        this.m_keyvalue = ConfigUtils.assertNotEmpty(keyvalue, "keyvalue");
    }

    public Integer getRecheckInterval() {
        return this.m_recheckInterval;
    }

    public void setRecheckInterval(Integer recheckInterval) {
        this.m_recheckInterval = ConfigUtils.assertNotNull(recheckInterval, "recheckInterval");
    }

    public String getIfType() {
        return this.m_ifType;
    }

    public void setIfType(String ifType) {
        this.m_ifType = ConfigUtils.assertNotEmpty(ifType, "ifType");
    }

    public String getResourceType() {
        return this.m_resourceType;
    }

    public void setResourceType(String resourceType) {
        this.m_resourceType = ConfigUtils.assertNotEmpty(resourceType, "resourceType");
    }

    public String getWmiNamespace() {
        return this.m_wmiNamespace == null ? "root/cimv2" : this.m_wmiNamespace;
    }

    public void setWmiNamespace(String wmiNamespace) {
        this.m_wmiNamespace = ConfigUtils.normalizeString(wmiNamespace);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Wpm)) {
            return false;
        }
        Wpm that = (Wpm)obj;
        return Objects.equals(this.m_attribs, that.m_attribs) && Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_wmiClass, that.m_wmiClass) && Objects.equals(this.m_keyvalue, that.m_keyvalue) && Objects.equals(this.m_recheckInterval, that.m_recheckInterval) && Objects.equals(this.m_ifType, that.m_ifType) && Objects.equals(this.m_resourceType, that.m_resourceType) && Objects.equals(this.m_wmiNamespace, that.m_wmiNamespace);
    }

    public int hashCode() {
        return Objects.hash(this.m_attribs, this.m_name, this.m_wmiClass, this.m_keyvalue, this.m_recheckInterval, this.m_ifType, this.m_resourceType, this.m_wmiNamespace);
    }
}

